/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.io;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.lang.ArrayHelper;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class UploadUtil {
    public static List<String> AUTHORIZED_IMAGE_EXTENSIONS = Arrays.asList("jpeg", "jpg", "png", "svg");
    public static List<String> AUTHORIZED_TEXT_EXTENSIONS = Arrays.asList("wsdl", "xml", "json", "txt");
    public static List<String> AUTHORIZED_EXTENSIONS = Arrays.asList(ArrayHelper.mergeArrays(AUTHORIZED_IMAGE_EXTENSIONS.toArray(new String[AUTHORIZED_IMAGE_EXTENSIONS.size()]), AUTHORIZED_TEXT_EXTENSIONS.toArray(new String[AUTHORIZED_TEXT_EXTENSIONS.size()])));

    public static String upload(String fileName, InputStream is, JSONObject data, String collaborationName, String knowledgeSpaceName, String applicationName, String userId) throws Exception {
        File rootDirectory;
        Object url = null;
        String category = null;
        String nodeOrUserOrProjectId = null;
        String type = null;
        QName ruleName = null;
        if (data != null) {
            if (data.has("category")) {
                category = data.getString("category");
            }
            if (data.has("nodeId") && (nodeOrUserOrProjectId = data.getString("nodeId")).contains("_c__")) {
                nodeOrUserOrProjectId = nodeOrUserOrProjectId.substring(0, nodeOrUserOrProjectId.indexOf("_c__"));
            }
            if (data.has("type")) {
                type = data.getString("type");
            }
            if (data.has("ruleName")) {
                ruleName = QName.valueOf(data.getString("ruleName"));
            }
            if (data.has("collaborationName")) {
                collaborationName = data.getString("collaborationName");
            }
            if (data.has("knowledgeSpaceName")) {
                knowledgeSpaceName = data.getString("knowledgeSpaceName");
            }
            if (data.has("fileName")) {
                fileName = data.getString("fileName");
            }
        }
        String extension = null;
        if (fileName.lastIndexOf(".") > 0) {
            extension = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        if (AUTHORIZED_EXTENSIONS.contains(extension.toLowerCase())) {
            rootDirectory = new File(RIOConstant.RESOURCES_FOLDER);
            if ("user".equals(category)) {
                rootDirectory = new File(rootDirectory, "users");
                if (nodeOrUserOrProjectId != null) {
                    userId = nodeOrUserOrProjectId;
                }
                rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(userId));
                rootDirectory = new File(rootDirectory, "pictures");
                url = "/" + applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/users/" + RegExpHelper.toRegexFriendlyName(userId) + "/pictures/" + fileName;
            } else if (knowledgeSpaceName != null) {
                rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(collaborationName));
                rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(knowledgeSpaceName.toLowerCase()));
                if (category != null && nodeOrUserOrProjectId != null) {
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName("resources"));
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(category));
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(nodeOrUserOrProjectId));
                    url = "/" + applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName(knowledgeSpaceName.toLowerCase()) + "/resources/" + RegExpHelper.toRegexFriendlyName(category) + "/" + RegExpHelper.toRegexFriendlyName(nodeOrUserOrProjectId) + "/" + fileName;
                } else if ("interpretation_rules".equals(category) && type != null && ruleName != null) {
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(category));
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(type));
                    rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName(ruleName.getLocalPart()));
                    rootDirectory = new File(rootDirectory, "resources");
                    url = "/" + applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName(knowledgeSpaceName.toLowerCase()) + "/" + RegExpHelper.toRegexFriendlyName(category) + "/" + RegExpHelper.toRegexFriendlyName(type) + "/" + RegExpHelper.toRegexFriendlyName(ruleName.getLocalPart()) + "/resources/" + fileName;
                } else {
                    url = "/" + applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName(knowledgeSpaceName.toLowerCase()) + "/" + fileName;
                }
            } else {
                rootDirectory = new File(rootDirectory, "share");
                rootDirectory = new File(rootDirectory, "external_resources");
                url = "/" + applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/share/external_resources/" + fileName;
            }
        } else {
            throw new Exception("Extension not take into account: " + extension);
        }
        url = ((String)url).replace("//", "/");
        rootDirectory.getCanonicalFile().mkdirs();
        File rsc = new File(rootDirectory.getCanonicalFile(), fileName);
        rsc.createNewFile();
        FileUtils.copyInputStreamToFile((InputStream)is, (File)rsc);
        if (url == null || ((String)url).isBlank()) {
            throw new Exception("url cannot be null or blank !!!");
        }
        System.out.println("url: " + (String)url);
        return url;
    }
}

