/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarHelper {
    private static XMLGregorianCalendarHelper INSTANCE = null;
    private DatatypeFactory datatypeFactory = DatatypeFactory.newDefaultInstance();

    private XMLGregorianCalendarHelper() throws Exception {
    }

    public static XMLGregorianCalendarHelper getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new XMLGregorianCalendarHelper();
        }
        return INSTANCE;
    }

    private DatatypeFactory getDatatypeFactory() {
        return this.datatypeFactory;
    }

    public XMLGregorianCalendar getNewCalendar(Date date) throws Exception {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(date);
        XMLGregorianCalendar calendar = INSTANCE.getDatatypeFactory().newXMLGregorianCalendar(gcal);
        calendar.setTimezone(Integer.MIN_VALUE);
        return calendar;
    }

    public XMLGregorianCalendar getNewCalendar(String dateAsString) throws Exception {
        XMLGregorianCalendar calendar = INSTANCE.getDatatypeFactory().newXMLGregorianCalendar(dateAsString);
        calendar.setTimezone(Integer.MIN_VALUE);
        return calendar;
    }

    public XMLGregorianCalendar getNewCalendar() throws Exception {
        return this.getNewCalendar(new Date());
    }
}

