/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import fr.emac.gind.commons.utils.xml.XMLTransform;
import fr.emac.gind.commons.utils.xml.resolver.ClasspathURIResolver;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPrettyPrinter {
    public static String print(Node node, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.print(node, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + String.valueOf(e));
        }
        return result;
    }

    public static String print(Node node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLPrettyPrinter.print(node, XMLPrettyPrinter.getEncoding((Document)node)) : XMLPrettyPrinter.print(node, XMLPrettyPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    public static void print(Node node, OutputStream out, String encoding) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        Transformer transformer = XMLPrettyPrinter.getTransformer(stylesheetSource);
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static void print(Node node, OutputStream out) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        Transformer transformer = XMLPrettyPrinter.getTransformer(stylesheetSource);
        transformer.transform(source, new StreamResult(out));
    }

    public static void print(InputStream in, OutputStream out) throws Exception {
        StreamSource source = new StreamSource(in);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        Transformer transformer = XMLPrettyPrinter.getTransformer(stylesheetSource);
        transformer.transform(source, new StreamResult(out));
    }

    public static Transformer getTransformer(Source stylesheetSource) throws TransformerConfigurationException {
        TransformerFactory transFact = XMLTransform.getInstance().getTransformerFactory();
        transFact.setURIResolver(new ClasspathURIResolver());
        Templates templates = transFact.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = null;
        try {
            encoding = xmlDocument.getInputEncoding();
            if (encoding == null) {
                encoding = xmlDocument.getXmlEncoding();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLPrettyPrinter.class.getResourceAsStream("/xslUtil/prettyPrint.xsl"));
        return stylesheetSource;
    }
}

