/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNamespaceOptimizer {
    private static final String PREFIXES = "qwertyuiopasdfghjklzxcvbnm";

    public static void optimizeNamespaces(Node dn) throws Exception {
        HashMap<String, String> context = new HashMap<String, String>();
        HashMap<String, String> allKnown = new HashMap<String, String>();
        List<Action> actions = XmlNamespaceOptimizer.collectNamespaces(dn, context, allKnown);
        XmlNamespaceOptimizer.addNamespacesToTopElement(dn, allKnown);
        for (Action action : actions) {
            if (action.newValue != null) continue;
            ((Element)action.parent).removeAttributeNode((Attr)action.node);
        }
        for (Action action : actions) {
            if (action.newValue == null) continue;
            Attr attr = (Attr)action.node;
            attr.setValue(action.newValue);
        }
    }

    private static String nextPrefix(int n) {
        int digit = n / PREFIXES.length() + 1;
        char c = PREFIXES.charAt(n % PREFIXES.length());
        String prefix = c + String.valueOf(digit > 1 ? Integer.valueOf(digit) : "");
        ++n;
        return prefix;
    }

    private static void addNamespacesToTopElement(Node dn, Map<String, String> allKnown) {
        Node top = dn;
        if (top.getNodeType() != 1) {
            top = dn.getChildNodes().item(0);
        }
        Element el = (Element)top;
        for (String uri : allKnown.keySet()) {
            String prefix = allKnown.get(uri);
            el.setAttribute("xmlns:" + prefix, uri);
        }
    }

    private static List<Action> collectNamespaces(Node node, Map<String, String> context, Map<String, String> allKnown) {
        ArrayList<Action> ret = new ArrayList<Action>();
        if (node == null) {
            return ret;
        }
        if (node.getNodeType() != 1) {
            return ret;
        }
        Element el = (Element)node;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            String val;
            String name;
            Node item;
            int a;
            for (a = 0; a < attrs.getLength(); ++a) {
                String prefix;
                item = attrs.item(a);
                name = item.getNodeName();
                val = item.getNodeValue();
                if (!name.startsWith("xmlns")) continue;
                if (!allKnown.containsKey(val)) {
                    allKnown.put(val, XmlNamespaceOptimizer.nextPrefix(allKnown.size()));
                }
                if ((prefix = name.substring("xmlns".length())).startsWith(":")) {
                    prefix = prefix.substring(1);
                }
                context.put(val, prefix);
                ret.add(new Action(node, item, null));
            }
            for (a = 0; a < attrs.getLength(); ++a) {
                String valVal;
                String valPfx;
                item = attrs.item(a);
                name = item.getNodeName();
                val = item.getNodeValue();
                if (name.startsWith("xmlns")) continue;
                String ownNs = XmlNamespaceOptimizer.countOwnNamespace(item, allKnown);
                String[] s = val.split("\\:", 2);
                if (s.length == 1) {
                    valPfx = null;
                    valVal = s[0];
                } else {
                    valPfx = s[0];
                    valVal = s[1];
                }
                String valNs = null;
                for (String ns : context.keySet()) {
                    String nsp = context.get(ns);
                    if (valPfx == null || !valPfx.equals(nsp)) continue;
                    valNs = ns;
                    break;
                }
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(ownNs) && "type".equals(item.getLocalName())) {
                    Attr attr = (Attr)item;
                    String newVal = allKnown.get("http://www.w3.org/2001/XMLSchema") + ":" + valVal;
                    ret.add(new Action(node, attr, newVal));
                    continue;
                }
                if (valNs == null) continue;
                throw new RuntimeException("Unrecognized attribute " + name + "'s value " + val + " has a prefix matching NS " + valNs);
            }
        }
        XmlNamespaceOptimizer.countOwnNamespace(node, allKnown);
        NodeList cns = node.getChildNodes();
        if (cns != null) {
            for (int i = 0; i < cns.getLength(); ++i) {
                Node cn = cns.item(i);
                HashMap<String, String> nestedContext = new HashMap<String, String>(context);
                List<Action> actions = XmlNamespaceOptimizer.collectNamespaces(cn, nestedContext, allKnown);
                ret.addAll(actions);
            }
        }
        return ret;
    }

    private static String countOwnNamespace(Node item, Map<String, String> namespaces) {
        String ownNs = item.getNamespaceURI();
        if (ownNs == null) {
            return null;
        }
        if (ownNs.trim().isEmpty()) {
            return null;
        }
        if (!namespaces.containsKey(ownNs)) {
            namespaces.put(ownNs, XmlNamespaceOptimizer.nextPrefix(namespaces.size()));
        }
        return ownNs;
    }

    private static class Action {
        public Node parent;
        public Node node;
        public String newValue;

        public Action(Node parent, Node node, String newValue) {
            this.parent = parent;
            this.node = node;
            this.newValue = newValue;
        }
    }
}

