/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.date;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;

public class DatePeriod {
    public LocalDate start = null;
    public LocalDate end = null;

    public DatePeriod(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    public Period getPeriod() {
        return Period.between(this.start, this.end);
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public long getNumberOfDays() {
        return ChronoUnit.DAYS.between(this.start, this.end);
    }

    public boolean isDatesOverLapped(DatePeriod period2) {
        if (this.getStart().isBefore(period2.getStart()) && this.getEnd().isAfter(period2.getStart()) || this.getStart().isBefore(period2.getEnd()) && this.getEnd().isAfter(period2.getEnd()) || this.getStart().isBefore(period2.getStart()) && this.getEnd().isAfter(period2.getEnd()) || this.getStart().isEqual(period2.getStart()) && this.getEnd().isEqual(period2.getEnd())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

