/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.process;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProcessHelper.class.getName());

    public static Optional<ProcessHandle> findProcess(String regexp) {
        return ProcessHandle.allProcesses().filter(ph -> ph.info().command().isPresent()).filter(ph -> ph.info().command().orElse("").matches(regexp)).findFirst();
    }

    public static List<ProcessHandle> findProcesses(String regexp) {
        return ProcessHandle.allProcesses().filter(ph -> ph.info().command().isPresent()).filter(ph -> ph.info().command().orElse("").matches(regexp)).collect(Collectors.toList());
    }

    public static void printAllProcess() {
        ProcessHandle.allProcesses().filter(ph -> ph.info().command().isPresent()).forEach(process -> ProcessHelper.dumpProcessInfo(process));
    }

    public static void dumpProcessInfo(ProcessHandle ph) {
        LOG.debug("PROCESS INFORMATION");
        LOG.debug("===================");
        System.out.printf("Process id: %d%n", ph.pid());
        ProcessHandle.Info info = ph.info();
        System.out.printf("Command: %s%n", info.command().orElse(""));
        String[] args = info.arguments().orElse(new String[0]);
        LOG.debug("Arguments:");
        for (String arg : args) {
            System.out.printf("   %s%n", arg);
        }
        System.out.printf("Command line: %s%n", info.commandLine().orElse(""));
        System.out.printf("Start time: %s%n", info.startInstant().orElse(Instant.now()).toString());
        System.out.printf("Run time duration: %sms%n", info.totalCpuDuration().orElse(Duration.ofMillis(0L)).toMillis());
        System.out.printf("Owner: %s%n", info.user().orElse(""));
        LOG.debug("");
    }
}

