<?xml version="1.0" encoding="UTF-8"?>
<!--

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


    first author: Nicolas SALATGE

-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" encoding="ISO-8859-1" />
	<xsl:param name="indent-increment" select="''" />
	<xsl:template name="newline">
	</xsl:template>
	<xsl:template match="comment() | processing-instruction()">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:copy />
	</xsl:template>
	<xsl:template match="text()">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:value-of select="normalize-space(.)" />
	</xsl:template>
	<xsl:template match="text()[normalize-space(.)='']" />
	<xsl:template match="*">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:choose>
			<xsl:when test="count(child::*) > 0">
				<xsl:copy>
					<xsl:copy-of select="@*" />
					<xsl:apply-templates select="*|text()">
						<xsl:with-param name="indent"
							select="concat ($indent, $indent-increment)" />
					</xsl:apply-templates>
					<xsl:call-template name="newline" />
					<xsl:value-of select="$indent" />
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
