/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;

public final class ArrayHelper {
    private ArrayHelper() {
    }

    public static <T> T[] mergeArrays(T[] ... arrays) {
        assert (arrays != null);
        assert (arrays.length > 0);
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        Object[] merged = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), totalLength);
        int destPos = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, merged, destPos, array.length);
            destPos += array.length;
        }
        return merged;
    }

    public static <T> T[] arrayRemove(T[] array, T ... toRemoveObjects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : array) {
            if (ArrayHelper.arrayContainsSameObject(toRemoveObjects, object)) continue;
            result.add(object);
        }
        return result.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), result.size()));
    }

    public static <T> boolean arrayContainsSameObject(T[] array, T sameObject) {
        for (T object : array) {
            if (object != sameObject) continue;
            return true;
        }
        return false;
    }
}

