/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientUtil {
    private static Logger LOG = LoggerFactory.getLogger(HTTPClientUtil.class);

    public static HttpResponse<String> sendHTTPRequest(HTTPProtocol protocol, String address, JSONObject payload, Long timeout, Integer retry, Map<String, String> header) throws Exception {
        HttpResponse<String> response = null;
        try {
            if (address == null) {
                throw new Exception("Address cannot be null !!!");
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(address));
            if (header != null) {
                for (Map.Entry<String, String> h : header.entrySet()) {
                    requestBuilder = requestBuilder.header(h.getKey(), h.getValue());
                }
            }
            if (header == null || header.get("content-type") == null) {
                requestBuilder = requestBuilder.header("Content-Type", "application/json");
                requestBuilder = requestBuilder.header("Accept", "application/json");
            }
            requestBuilder = requestBuilder.header("User-Agent", "Gind");
            if (timeout != null) {
                LOG.debug("set timeout on http " + String.valueOf((Object)protocol) + " request: " + timeout);
                requestBuilder = requestBuilder.timeout(Duration.ofMillis(timeout));
            }
            switch (protocol.ordinal()) {
                case 0: {
                    requestBuilder = requestBuilder.GET();
                    break;
                }
                case 1: {
                    if (payload == null) {
                        throw new Exception("Payload cannot be null !!!");
                    }
                    requestBuilder = requestBuilder.POST(HttpRequest.BodyPublishers.ofString(payload.toString()));
                    break;
                }
                case 2: {
                    if (payload == null) {
                        throw new Exception("Payload cannot be null !!!");
                    }
                    requestBuilder = requestBuilder.PUT(HttpRequest.BodyPublishers.ofString(payload.toString()));
                    break;
                }
                case 3: {
                    requestBuilder = requestBuilder.DELETE();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)protocol));
                }
            }
            if (retry == null || retry <= 1) {
                LOG.debug("send " + String.valueOf((Object)protocol) + " at address: " + address);
                response = HttpClient.newBuilder().build().send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            } else {
                for (int i = 0; i < retry; ++i) {
                    try {
                        LOG.debug("send " + String.valueOf((Object)protocol) + " at address: " + address + " (retry: " + (i + 1) + "/" + retry + ")");
                        response = HttpClient.newBuilder().build().send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() == 200) {
                            LOG.debug("response succesfull on retry " + (i + 1) + "/" + retry);
                            break;
                        }
                        LOG.warn("Error on retry " + (i + 1) + "/" + retry + " : http error code => " + response.statusCode());
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn("Error on retry " + (i + 1) + "/" + retry + " : " + e.getMessage());
                        if (i == retry - 1) {
                            throw new RuntimeException("Error after " + retry + " retry", e);
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            LOG.debug("receive " + String.valueOf((Object)protocol) + " response from address: " + address + " => status code: " + response.statusCode());
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            throw e;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpResponse<String> sendHTTPRequestByAnotherImpl(HTTPProtocol protocol, String address, JSONObject payload, Long timeout, Map<String, String> header) throws Exception {
        HttpResponse<String> response = null;
        if (address == null) {
            throw new Exception("Address cannot be null !!!");
        }
        HttpURLConnection connexion = null;
        try {
            URL obj = new URL(address);
            connexion = (HttpURLConnection)obj.openConnection();
            if (header != null) {
                for (Map.Entry<String, String> h : header.entrySet()) {
                    connexion.setRequestProperty(h.getKey(), h.getValue());
                }
            }
            if (header == null || header.get("content-type") == null) {
                connexion.setRequestProperty("Content-Type", "application/json");
                connexion.setRequestProperty("Accept", "application/json");
            }
            connexion.setRequestProperty("User-Agent", "Gind");
            if (timeout != null) {
                connexion.setConnectTimeout(timeout.intValue());
            }
            switch (protocol.ordinal()) {
                case 0: {
                    throw new Exception("Not implemented !!!");
                }
                case 1: {
                    if (payload == null) {
                        throw new Exception("Payload cannot be null !!!");
                    }
                    connexion.setDoOutput(true);
                    try (OutputStream os = connexion.getOutputStream();){
                        byte[] input = payload.toString().getBytes("utf-8");
                        os.write(input, 0, input.length);
                    }
                    final int responseCode = connexion.getResponseCode();
                    System.out.println("Response Code: " + responseCode);
                    final StringBuilder jsonResponse = new StringBuilder();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(connexion.getInputStream(), "utf-8"));){
                        String responseLine;
                        while ((responseLine = br.readLine()) != null) {
                            jsonResponse.append(responseLine.trim());
                        }
                    }
                    response = new HttpResponse<String>(){

                        @Override
                        public int statusCode() {
                            return responseCode;
                        }

                        @Override
                        public HttpRequest request() {
                            return null;
                        }

                        @Override
                        public Optional<HttpResponse<String>> previousResponse() {
                            return Optional.empty();
                        }

                        @Override
                        public HttpHeaders headers() {
                            return null;
                        }

                        @Override
                        public String body() {
                            return jsonResponse.toString();
                        }

                        @Override
                        public Optional<SSLSession> sslSession() {
                            return Optional.empty();
                        }

                        @Override
                        public URI uri() {
                            return null;
                        }

                        @Override
                        public HttpClient.Version version() {
                            return null;
                        }
                    };
                    return response;
                }
                case 2: {
                    if (payload != null) throw new Exception("Not implemented !!!");
                    throw new Exception("Payload cannot be null !!!");
                }
                case 3: {
                    throw new Exception("Not implemented !!!");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)protocol));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return response;
        }
        finally {
            if (connexion != null) {
                connexion.disconnect();
            }
        }
    }

    public static enum HTTPProtocol {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

