/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.tree;

import java.util.ArrayList;
import java.util.List;

public class Tree<T> {
    private T item;
    private Tree<T> parent;
    private List<Tree<T>> children = new ArrayList<Tree<T>>();

    public Tree(T rootData) {
        this.item = rootData;
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T data) {
        this.item = data;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public Tree<T> addChildren(T data) {
        Tree<T> child = new Tree<T>(data);
        child.parent = this;
        this.children.add(child);
        return child;
    }

    public String toString() {
        return "Node [data=" + String.valueOf(this.item) + ", children=" + String.valueOf(this.children) + "]";
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public boolean isParentOf(Tree<T> child) {
        for (Tree<T> c : this.children) {
            if (!c.getItem().equals(child.getItem())) continue;
            return true;
        }
        return false;
    }
}

