/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import fr.emac.gind.commons.utils.CommonUtilException;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMUtil {
    private DocumentBuilderFactory domBuilderFactory = null;
    private ThreadLocal<DocumentBuilder> domBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DOMUtil.this.domBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    };
    private static DOMUtil INSTANCE;

    private DOMUtil() throws Exception {
        this.domBuilderFactory = DocumentBuilderFactory.newInstance();
        this.domBuilderFactory.setNamespaceAware(true);
    }

    public static DOMUtil getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new DOMUtil();
        }
        return INSTANCE;
    }

    public Document newDocument() throws Exception {
        return this.domBuilder.get().newDocument();
    }

    public Document parse(URL url) throws Exception {
        return this.domBuilder.get().parse(url.openStream());
    }

    public Document parse(File file) throws Exception {
        return this.domBuilder.get().parse(file);
    }

    public Document parse(InputStream stream) throws Exception {
        return this.domBuilder.get().parse(stream);
    }

    public Document parse(InputSource source) throws Exception {
        return this.domBuilder.get().parse(source);
    }

    public Element findFirstElementByNs(Element parent, QName name) {
        Element res = null;
        if (parent != null) {
            NodeList list = parent.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                res = (Element)list.item(i);
                break;
            }
        }
        return res;
    }

    public Element getFirstElement(Element parent) {
        Element res = null;
        if (parent != null) {
            NodeList list = parent.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                res = (Element)list.item(i);
                break;
            }
        }
        return res;
    }

    public List<Element> findElementsByNs(Element parent, QName name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (parent != null) {
            NodeList list = parent.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                res.add((Element)list.item(i));
            }
        }
        return res;
    }

    public List<Element> findElementsByNameWithoutNS(Element parent, String name, boolean recursively) {
        ArrayList<Element> res;
        block4: {
            res = new ArrayList<Element>();
            if (parent == null) break block4;
            if (recursively) {
                NodeList list = parent.getElementsByTagName(name);
                for (int i = 0; i < list.getLength(); ++i) {
                    if (list.item(i).getNodeType() != 1) continue;
                    res.add((Element)list.item(i));
                }
            } else {
                List<Element> childElements = this.getElements(parent);
                for (Element elmt : childElements) {
                    if (!elmt.getNodeName().equals(name)) continue;
                    res.add(elmt);
                }
            }
        }
        return res;
    }

    public List<Element> getElements(Element parent) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (parent != null) {
            NodeList list = parent.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                res.add((Element)list.item(i));
            }
        }
        return res;
    }

    public Document createDocumentFromElement(Element elmt) throws ParserConfigurationException {
        Document doc = this.domBuilder.get().newDocument();
        doc.appendChild((Element)doc.importNode(elmt.cloneNode(true), true));
        return doc;
    }

    public Document convertFirstElementIntoDocument(DocumentBuilderFactory factory, Document in) throws CommonUtilException {
        Document res = null;
        try {
            res = factory.newDocumentBuilder().newDocument();
            Element first = this.getFirstElement(in.getDocumentElement());
            if (first != null) {
                res.appendChild(res.importNode(first.cloneNode(true), true));
            }
        }
        catch (ParserConfigurationException e) {
            throw new CommonUtilException(e);
        }
        return res;
    }

    public void clean(Element destination, boolean cleanAttribute) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < destination.getChildNodes().getLength(); ++i) {
            nodes.add(destination.getChildNodes().item(i));
        }
        for (Node n : nodes) {
            destination.removeChild(n);
        }
        if (cleanAttribute) {
            ArrayList<Attr> attrs = new ArrayList<Attr>();
            for (int i = 0; i < destination.getAttributes().getLength(); ++i) {
                attrs.add((Attr)destination.getAttributes().item(i));
            }
            for (Attr a : attrs) {
                destination.removeAttributeNode(a);
            }
        }
    }
}

