/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import fr.emac.gind.commons.utils.pooling.GenericResourcePool;
import fr.emac.gind.commons.utils.pooling.PoolPolicy;
import fr.emac.gind.commons.utils.pooling.ResourceHandler;
import fr.emac.gind.commons.utils.xml.XMLTransform;
import fr.emac.gind.commons.utils.xml.resolver.ClasspathURIResolver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLCompactPrinter {
    private static GenericResourcePool<TransformerFactory> transformerFactoryResourcePool = new GenericResourcePool<TransformerFactory>(new TransformerFactoryResourceHandler(), 1, Integer.MAX_VALUE, PoolPolicy.WAIT);

    public static String print(Node node, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLCompactPrinter.print(node, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + String.valueOf(e));
        }
        if (result != null && result.indexOf("?>") > 0) {
            result = result.substring(result.indexOf("?>") + "?>".length());
        }
        return result;
    }

    public static String print(Node node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLCompactPrinter.print(node, XMLCompactPrinter.getEncoding((Document)node)) : XMLCompactPrinter.print(node, XMLCompactPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    private static void print(Node node, OutputStream out, String encoding) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLCompactPrinter.getStyleSheetSource();
        Transformer transformer = XMLCompactPrinter.getTransformer(stylesheetSource);
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static Transformer getTransformer(Source stylesheetSource) throws TransformerConfigurationException {
        TransformerFactory transFact = XMLTransform.getInstance().getTransformerFactory();
        transFact.setURIResolver(new ClasspathURIResolver());
        Templates templates = transFact.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = xmlDocument.getInputEncoding();
        if (encoding == null) {
            encoding = xmlDocument.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLCompactPrinter.class.getResourceAsStream("/xslUtil/compactPrint.xsl"));
        return stylesheetSource;
    }

    private static class TransformerFactoryResourceHandler
    implements ResourceHandler<TransformerFactory> {
        private TransformerFactoryResourceHandler() {
        }

        @Override
        public TransformerFactory create() {
            return TransformerFactory.newInstance();
        }

        @Override
        public void onTake(TransformerFactory resource) {
        }

        @Override
        public void onRelease(TransformerFactory resource) {
        }
    }
}

