/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.io.FileDeleteStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger LOG = LoggerFactory.getLogger((String)FileUtil.class.getName());

    public static File[] getAllFiles(File parentDir) {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null && parentDir.isDirectory()) {
            for (File file : parentDir.listFiles()) {
                if (file.isFile()) {
                    list.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                list.addAll(Arrays.asList(FileUtil.getAllFiles(file)));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static File[] findFilesByName(File parentDir, String name) {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null && parentDir.isDirectory()) {
            for (File file : parentDir.listFiles()) {
                if (file.isFile() && file.getName().contains(name)) {
                    list.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                list.addAll(Arrays.asList(FileUtil.findFilesByName(file, name)));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static File[] findFilesByExtension(File parentDir, String extension) {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null && parentDir.isDirectory()) {
            for (File file : parentDir.listFiles()) {
                if (file.isFile() && file.getName().endsWith(extension)) {
                    list.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                list.addAll(Arrays.asList(FileUtil.findFilesByExtension(file, extension)));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream source, OutputStream destination) {
        boolean resultat = false;
        InputStream sourceFile = null;
        OutputStream destinationFile = null;
        try {
            int nbLecture;
            sourceFile = source;
            destinationFile = destination;
            byte[] buffer = new byte[524288];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, nbLecture);
            }
            resultat = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception exception) {}
            try {
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                try {
                    FileDeleteStrategy.FORCE.delete(files[i]);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    files[i].delete();
                }
            }
        }
        return path.delete();
    }

    public static String getExtension(String file) {
        String ext = null;
        if (file.lastIndexOf(".") > 0) {
            ext = file.substring(file.lastIndexOf(".") + 1);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new FileReader(aFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(InputStream stream) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(stream));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage());
        }
        return contents.toString();
    }

    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + String.valueOf(aFile));
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + String.valueOf(aFile));
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + String.valueOf(aFile));
        }
        try (BufferedWriter output = new BufferedWriter(new FileWriter(aFile));){
            output.write(aContents);
        }
    }

    public static void copy(File sourceFile, File destFile) throws Exception {
        if (sourceFile.isDirectory()) {
            for (File file : sourceFile.listFiles()) {
                FileUtil.copy(file, new File(destFile, file.getName()));
            }
        } else {
            try {
                Files.copy(Paths.get(sourceFile.getPath(), new String[0]), Paths.get(destFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
    }

    public static void append(File file, String print, boolean debug) throws Exception {
        if (debug) {
            if (!file.exists()) {
                file.createNewFile();
            }
            String buffer = FileUtil.getContents(file);
            FileUtil.setContents(file, buffer + print);
        }
    }

    public static File extractFileFromZip(String uri) throws IOException {
        String fileName = uri;
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        LOG.info(fileName);
        File parentFolder = new File(new File(System.getProperty("java.io.tmpdir")), "extract-from-zip-" + String.valueOf(UUID.randomUUID()));
        Files.createDirectory(parentFolder.toPath(), new FileAttribute[0]);
        assert (parentFolder.exists() && parentFolder.isDirectory());
        File file = new File(parentFolder, fileName);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        assert (file.exists());
        String localPathInJar = uri.split("!")[1].substring(1);
        LOG.debug(localPathInJar);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(localPathInJar);
        LOG.debug(String.valueOf(is));
        FileUtil.copy(is, new FileOutputStream(file));
        return file;
    }
}

