/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.maths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PermutationHelper {
    public static <T> List<List<T>> getPermutations(List<T> list, Integer maxLimit) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        PermutationHelper.permute(list, 0, result, maxLimit);
        return result;
    }

    private static <T> void permute(List<T> list, int index, List<List<T>> result, Integer maxLimit) {
        if (maxLimit != null && result.size() >= maxLimit) {
            return;
        }
        if (index == list.size() - 1) {
            result.add(new ArrayList<T>(list));
            return;
        }
        for (int i = index; i < list.size(); ++i) {
            Collections.swap(list, i, index);
            PermutationHelper.permute(list, index + 1, result, maxLimit);
            Collections.swap(list, i, index);
        }
    }

    public static void main(String[] args) {
        List<String> items = Arrays.asList("A", "B", "C");
        List<List<String>> permutations = PermutationHelper.getPermutations(items, null);
        for (List<String> perm : permutations) {
            System.out.println(perm);
        }
    }
}

