/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLNSCleaner {
    private static final Logger LOG = LoggerFactory.getLogger((String)XMLNSCleaner.class.getName());
    private static Pattern pattern;
    private static Matcher matcher;

    public static String clean(String dirtyDoc) {
        String cleanDoc = dirtyDoc;
        HashMap mapPrefixsByNS = new HashMap();
        pattern = Pattern.compile("xmlns:([\\S]*)=\"([\\S]*)\"");
        matcher = pattern.matcher(dirtyDoc);
        while (matcher.find()) {
            Object ns = null;
            String prefix = null;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                if (i == 1) {
                    prefix = matcher.group(1);
                }
                if (i != 2) continue;
                ns = matcher.group(2);
            }
            if (mapPrefixsByNS.get(ns) == null) {
                ArrayList<String> prefixs = new ArrayList<String>();
                prefixs.add(prefix);
                mapPrefixsByNS.put(ns, prefixs);
                continue;
            }
            ((List)mapPrefixsByNS.get(ns)).add(prefix);
        }
        for (Map.Entry entry : mapPrefixsByNS.entrySet()) {
            List prefixes = (List)entry.getValue();
            for (String prefix : new ArrayList(prefixes)) {
                if (dirtyDoc.indexOf(prefix + ":") != -1) continue;
                prefixes.remove(prefix);
            }
        }
        for (Map.Entry entry : mapPrefixsByNS.entrySet()) {
            String ns = (String)entry.getKey();
            List prefixes = (List)entry.getValue();
            if (prefixes.size() != 0) continue;
            try {
                cleanDoc = cleanDoc.replaceAll("xmlns:[\\S]*=\"" + ns + "\"", "");
            }
            catch (Exception e) {
                LOG.debug("Error: " + e.getMessage());
            }
        }
        Pattern p = Pattern.compile("<([^>]*)>");
        Matcher m = p.matcher(cleanDoc);
        while (m.find()) {
            String elmtWithWhiteSpaces = m.group();
            String elmtWithoutWhiteSpaces = elmtWithWhiteSpaces.replaceAll("[\\s]+", " ");
            cleanDoc = cleanDoc.replace(elmtWithWhiteSpaces, elmtWithoutWhiteSpaces);
        }
        return cleanDoc;
    }
}

