/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.gis;

import fr.emac.gind.commons.gis.distance.api.DistanceTimeItf;
import fr.emac.gind.commons.gis.distance.impl.DistanceTimeGoogleMaps;
import fr.emac.gind.commons.gis.distance.impl.DistanceTimeInternal;
import fr.emac.gind.commons.gis.distance.impl.DistanceTimeMapQuest;
import fr.emac.gind.commons.gis.distance.impl.DistanceTimeOpenRoute;
import fr.emac.gind.distance.data.GJaxbDistanceTimeMatrix;
import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceTimeMatrixManager
implements DistanceTimeItf {
    private static Logger LOG = LoggerFactory.getLogger((String)DistanceTimeMatrixManager.class.getName());
    private GisAPI distanceTimeCalculatorSelected = GisAPI.INTERNAL_API;
    private Map<GisAPI, DistanceTimeItf> mapDistanceCalculators = new HashMap<GisAPI, DistanceTimeItf>();
    private GJaxbDistanceTimeMatrix cachedMatrix = null;
    private List<GJaxbPair> cache = null;

    public DistanceTimeMatrixManager(GJaxbNode userNode, GJaxbDistanceTimeMatrix cacheM) throws Exception {
        this.cachedMatrix = cacheM != null ? cacheM : new GJaxbDistanceTimeMatrix();
        this.cache = Collections.synchronizedList(this.cachedMatrix.getPair());
        String mapQuestKey = null;
        GJaxbProperty mapQuestProp = GenericModelHelper.findProperty((String)"mapquest-key", (List)userNode.getProperty());
        if (mapQuestProp != null && mapQuestProp.getValue() != null && !mapQuestProp.getValue().trim().isEmpty()) {
            mapQuestKey = mapQuestProp.getValue().trim();
        }
        String openRouteKey = null;
        GJaxbProperty openRouteProp = GenericModelHelper.findProperty((String)"openrouteservice-key", (List)userNode.getProperty());
        if (openRouteProp != null && openRouteProp.getValue() != null && !openRouteProp.getValue().trim().isEmpty()) {
            openRouteKey = openRouteProp.getValue().trim();
        }
        String googleKey = null;
        GJaxbProperty googleMapsProp = GenericModelHelper.findProperty((String)"googlemaps-key", (List)userNode.getProperty());
        if (googleMapsProp != null && googleMapsProp.getValue() != null && !googleMapsProp.getValue().trim().isEmpty()) {
            googleKey = googleMapsProp.getValue().trim();
        } else if (System.getenv("GOOGLE_API_KEY") != null) {
            googleKey = System.getenv("GOOGLE_API_KEY");
        }
        this.mapDistanceCalculators.put(GisAPI.INTERNAL_API, new DistanceTimeInternal());
        if (mapQuestKey != null) {
            this.mapDistanceCalculators.put(GisAPI.MAPQUEST_API, new DistanceTimeMapQuest(mapQuestKey));
            this.distanceTimeCalculatorSelected = GisAPI.MAPQUEST_API;
        } else {
            LOG.warn("No key found for MapQuest API !!!");
        }
        if (openRouteKey != null) {
            this.mapDistanceCalculators.put(GisAPI.OPENROUTESERVICE_API, new DistanceTimeOpenRoute(openRouteKey));
            this.distanceTimeCalculatorSelected = GisAPI.OPENROUTESERVICE_API;
        } else {
            LOG.warn("No key found for OpenRoute API !!!");
        }
        if (googleKey != null) {
            this.mapDistanceCalculators.put(GisAPI.GOOGLE_MAPS_API, new DistanceTimeGoogleMaps(googleKey));
            this.distanceTimeCalculatorSelected = GisAPI.GOOGLE_MAPS_API;
        } else {
            LOG.warn("No key found for Google Maps API !!!");
        }
    }

    public DistanceTimeMatrixManager(GJaxbNode userNode) throws Exception {
        this(userNode, null);
    }

    public GisAPI getDistanceTimeCalculatorSelected() {
        return this.distanceTimeCalculatorSelected;
    }

    public void setDistanceTimeCalculatorSelected(GisAPI type) {
        if (!type.equals((Object)this.distanceTimeCalculatorSelected)) {
            this.cache.clear();
        }
        this.distanceTimeCalculatorSelected = type;
    }

    public void clearCache() {
        this.cache.clear();
    }

    private void addPairInCache(GJaxbPair pair) {
        this.cache.add(pair);
    }

    @Override
    public GJaxbPair findJourney(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        GJaxbPair pair = this.findInCachedMatrix(departure, destination);
        if (pair != null) {
            return pair;
        }
        DistanceTimeItf distanceTimeCalculator = this.mapDistanceCalculators.get((Object)this.distanceTimeCalculatorSelected);
        pair = distanceTimeCalculator.findJourney(departure, destination);
        this.addPairInCache(pair);
        return pair;
    }

    private GJaxbPair findInCachedMatrix(GJaxbLocalization departure, GJaxbLocalization destination) {
        for (GJaxbPair pair : this.cache) {
            if (pair == null) continue;
            if (departure.getId() != null && destination.getId() != null && pair.getLocalizationStart().getLocalization().getId().equals(departure.getId()) && pair.getLocalizationEnd().getLocalization().getId().equals(destination.getId())) {
                return pair;
            }
            if (departure.getName() != null && destination.getName() != null && pair.getLocalizationStart().getLocalization().getName() != null && pair.getLocalizationEnd().getLocalization().getName() != null && pair.getLocalizationStart().getLocalization().getName().equals(departure.getName()) && pair.getLocalizationEnd().getLocalization().getName().equals(destination.getName())) {
                return pair;
            }
            if (!this.equalsGeoLoc(pair.getLocalizationStart().getLocalization(), departure) || !this.equalsGeoLoc(pair.getLocalizationEnd().getLocalization(), destination)) continue;
            return pair;
        }
        return null;
    }

    public boolean equalsGeoLoc(GJaxbLocalization a, GJaxbLocalization b) {
        return a.getPoint().getLatitude() == b.getPoint().getLatitude() && a.getPoint().getLongitude() == b.getPoint().getLongitude() && a.getPoint().getAltitude() == b.getPoint().getAltitude();
    }

    public double findTime(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        return ((GJaxbLeg)((GJaxbRoute)this.findJourney(departure, destination).getRoute().get(0)).getLeg().get(0)).getDuration();
    }

    public double findDistance(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        double res = ((GJaxbLeg)((GJaxbRoute)this.findJourney(departure, destination).getRoute().get(0)).getLeg().get(0)).getDistance();
        return res;
    }

    public static GJaxbLocalization createLocalisation(String id, String name, double latitude, double longitude, double altitude) {
        GJaxbLocalization res = new GJaxbLocalization();
        res.setId(id);
        res.setName(name);
        res.setPoint(new GJaxbPointType());
        res.getPoint().setLatitude(Double.valueOf(latitude));
        res.getPoint().setLongitude(Double.valueOf(longitude));
        res.getPoint().setAltitude(Double.valueOf(altitude));
        return res;
    }

    public GJaxbDistanceTimeMatrix getCachedMatrix() {
        return this.cachedMatrix;
    }

    public static enum GisAPI {
        INTERNAL_API,
        MAPQUEST_API,
        OPENROUTESERVICE_API,
        GOOGLE_MAPS_API;

    }
}

