/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.gis.distance.impl;

import com.google.maps.DirectionsApi;
import com.google.maps.GeoApiContext;
import com.google.maps.model.DirectionsLeg;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.DirectionsRoute;
import com.google.maps.model.DirectionsStep;
import com.google.maps.model.LatLng;
import com.google.maps.model.Unit;
import fr.emac.gind.commons.gis.distance.api.DistanceTimeItf;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import fr.emac.gind.distance.data.GJaxbStep;
import fr.emac.gind.distance.data.GJaxbTravelMode;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import org.w3c.dom.Node;

public class DistanceTimeGoogleMaps
implements DistanceTimeItf {
    private String googleMapsKey = null;
    private GeoApiContext geoApiContext = null;

    public DistanceTimeGoogleMaps(String key) {
        this.googleMapsKey = key;
        this.geoApiContext = new GeoApiContext.Builder().apiKey(this.googleMapsKey).build();
    }

    @Override
    public GJaxbPair findJourney(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        GJaxbPair pair = null;
        if (departure != null && departure.getPoint() != null && departure.getPoint().isSetLatitude() && departure.getPoint().isSetLongitude() && departure != null && departure.getPoint() != null && departure.getPoint().isSetLatitude() && departure.getPoint().isSetLongitude() && destination != null && destination.getPoint() != null && destination.getPoint().isSetLatitude() && destination.getPoint().isSetLongitude() && destination != null && destination.getPoint() != null && destination.getPoint().isSetLatitude() && destination.getPoint().isSetLongitude()) {
            pair = new GJaxbPair();
            pair.setLocalizationStart(new GJaxbPair.LocalizationStart());
            pair.getLocalizationStart().setLocalization(departure);
            pair.setLocalizationEnd(new GJaxbPair.LocalizationEnd());
            pair.getLocalizationEnd().setLocalization(destination);
            DirectionsResult result = (DirectionsResult)DirectionsApi.newRequest((GeoApiContext)this.geoApiContext).departureTimeNow().origin(new LatLng(departure.getPoint().getLatitude().doubleValue(), departure.getPoint().getLongitude().doubleValue())).destination(new LatLng(destination.getPoint().getLatitude().doubleValue(), destination.getPoint().getLongitude().doubleValue())).units(Unit.METRIC).await();
            for (DirectionsRoute dirRoute : result.routes) {
                GJaxbRoute route = new GJaxbRoute();
                for (DirectionsLeg dirLeg : dirRoute.legs) {
                    GJaxbLeg leg = new GJaxbLeg();
                    leg.setDistance((double)dirLeg.distance.inMeters);
                    leg.setDistanceHumanReadable(dirLeg.distance.humanReadable);
                    leg.setDuration((double)dirLeg.duration.inSeconds);
                    leg.setDurationHumanReadable(dirLeg.duration.humanReadable);
                    leg.setDurationInTraffic((double)dirLeg.durationInTraffic.inSeconds);
                    leg.setDurationInTrafficHumanReadable(dirLeg.durationInTraffic.humanReadable);
                    leg.setStartAddress(dirLeg.startAddress);
                    GJaxbPointType startPoint = new GJaxbPointType();
                    startPoint.setLatitude(Double.valueOf(dirLeg.startLocation.lat));
                    startPoint.setLongitude(Double.valueOf(dirLeg.startLocation.lng));
                    leg.setStartLocation(new GJaxbLeg.StartLocation());
                    leg.getStartLocation().setPoint(startPoint);
                    leg.setEndAddress(dirLeg.endAddress);
                    GJaxbPointType endPoint = new GJaxbPointType();
                    endPoint.setLatitude(Double.valueOf(dirLeg.endLocation.lat));
                    endPoint.setLongitude(Double.valueOf(dirLeg.endLocation.lng));
                    leg.setEndLocation(new GJaxbLeg.EndLocation());
                    leg.getEndLocation().setPoint(endPoint);
                    for (DirectionsStep dirStep : dirLeg.steps) {
                        GJaxbStep step = new GJaxbStep();
                        step.setDistance((double)dirStep.distance.inMeters);
                        step.setDistanceHumanReadable(dirStep.distance.humanReadable);
                        step.setDuration((double)dirStep.duration.inSeconds);
                        step.setDurationHumanReadable(dirStep.duration.humanReadable);
                        GJaxbPointType startPointLeg = new GJaxbPointType();
                        startPointLeg.setLatitude(Double.valueOf(dirStep.startLocation.lat));
                        startPointLeg.setLongitude(Double.valueOf(dirStep.startLocation.lng));
                        step.setStartLocation(new GJaxbStep.StartLocation());
                        step.getStartLocation().setPoint(startPointLeg);
                        GJaxbPointType endPointLeg = new GJaxbPointType();
                        endPointLeg.setLatitude(Double.valueOf(dirStep.endLocation.lat));
                        endPointLeg.setLongitude(Double.valueOf(dirStep.endLocation.lng));
                        step.setEndLocation(new GJaxbStep.EndLocation());
                        step.getEndLocation().setPoint(endPointLeg);
                        step.setHtmlInstructions(dirStep.htmlInstructions);
                        step.setManeuver(dirStep.maneuver);
                        step.setTravelMode(GJaxbTravelMode.fromValue((String)dirStep.travelMode.toString().toUpperCase()));
                        step.setPolyline(new GJaxbStep.Polyline());
                        for (LatLng latlng : dirStep.polyline.decodePath()) {
                            GJaxbPointType pt = new GJaxbPointType();
                            pt.setLatitude(Double.valueOf(latlng.lat));
                            pt.setLongitude(Double.valueOf(latlng.lng));
                            step.getPolyline().getPoint().add(pt);
                        }
                        leg.getStep().add(step);
                    }
                    route.getLeg().add(leg);
                }
                route.setSummary(dirRoute.summary);
                route.setOverviewPolyline(new GJaxbRoute.OverviewPolyline());
                for (LatLng latlng : dirRoute.overviewPolyline.decodePath()) {
                    GJaxbPointType pt = new GJaxbPointType();
                    pt.setLatitude(Double.valueOf(latlng.lat));
                    pt.setLongitude(Double.valueOf(latlng.lng));
                    route.getOverviewPolyline().getPoint().add(pt);
                }
                pair.getRoute().add(route);
            }
            System.out.println("google pair result: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)pair)));
        }
        return pair;
    }
}

