/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.gis.distance.impl;

import fr.emac.gind.commons.gis.distance.api.DistanceTimeItf;
import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceTimeOpenRoute
implements DistanceTimeItf {
    private static Logger LOG = LoggerFactory.getLogger((String)DistanceTimeOpenRoute.class.getName());
    public static long OPENROUTESERVICE_CALLS = 0L;
    private String openRouteKey = null;

    public DistanceTimeOpenRoute(String key) {
        this.openRouteKey = key;
    }

    @Override
    public GJaxbPair findJourney(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        GJaxbPair pair = new GJaxbPair();
        pair.setLocalizationStart(new GJaxbPair.LocalizationStart());
        pair.getLocalizationStart().setLocalization(departure);
        pair.setLocalizationEnd(new GJaxbPair.LocalizationEnd());
        pair.getLocalizationEnd().setLocalization(destination);
        Client client = ClientBuilder.newClient();
        Object link = "https://api.openrouteservice.org/directions?";
        link = (String)link + "&coordinates=" + departure.getPoint().getLongitude() + "%2C" + departure.getPoint().getLatitude();
        link = (String)link + "%7C" + destination.getPoint().getLongitude() + "%2C" + destination.getPoint().getLatitude();
        link = (String)link + "&profile=driving-car&preference=fastest";
        link = (String)link + "&units=km";
        link = (String)link + "&language=en";
        link = (String)link + "&geometry=true&geometry_format=geojson";
        link = (String)link + "&instructions=false&instructions_format=text";
        link = (String)link + "&options=%7B%7D";
        link = (String)link + "&id=abc";
        link = (String)link + "&api_key=" + this.openRouteKey;
        LOG.debug("Requesting OpenRouteService " + (String)link);
        WebTarget webResource = client.target((String)link);
        Response response = webResource.request().buildGet().invoke();
        ++OPENROUTESERVICE_CALLS;
        if (response.getStatus() != 200) {
            String error = (String)response.readEntity(String.class);
            LOG.debug("Error from Server .... \n");
            LOG.debug(error);
            if (response.getStatus() == 429) {
                Thread.sleep(5000L);
                return this.findJourney(departure, destination);
            }
            throw new Exception("Failed on OSM Server (HTTP error code : " + response.getStatus() + ") : " + error);
        }
        String output = (String)response.readEntity(String.class);
        LOG.debug("OpenRouteService Response (" + OPENROUTESERVICE_CALLS + ") " + output);
        JSONObject jsonAPI = new JSONObject(output);
        JSONArray journey = jsonAPI.getJSONArray("routes").getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates");
        JSONArray travel = new JSONArray();
        String departureString = "{\"lat\":" + departure.getPoint().getLatitude() + ",\"lng\":" + departure.getPoint().getLongitude() + "}";
        travel.put((Object)new JSONObject(departureString));
        for (int i = 0; i < journey.length(); ++i) {
            JSONArray move = journey.getJSONArray(i);
            Object jsonString = "{\"lat\":";
            jsonString = (String)jsonString + String.valueOf(move.get(1));
            jsonString = (String)jsonString + ",\"lng\":";
            jsonString = (String)jsonString + String.valueOf(move.get(0));
            jsonString = (String)jsonString + "}";
            travel.put((Object)new JSONObject((String)jsonString));
        }
        String destinationString = "{\"lat\":" + destination.getPoint().getLatitude() + ",\"lng\":" + destination.getPoint().getLongitude() + "}";
        travel.put((Object)new JSONObject(destinationString));
        GJaxbRoute route = new GJaxbRoute();
        GJaxbLeg leg = new GJaxbLeg();
        leg.setDuration(Double.parseDouble(jsonAPI.getJSONArray("routes").getJSONObject(0).getJSONObject("summary").get("duration").toString()));
        leg.setDistance(1000.0 * Double.parseDouble(jsonAPI.getJSONArray("routes").getJSONObject(0).getJSONObject("summary").get("distance").toString()));
        route.getLeg().add(leg);
        route.setSummary(travel.toString());
        pair.getRoute().add(route);
        return pair;
    }
}

