/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPredefinedShape;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbFormtypeType;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelModelReader {
    private static Logger LOG = LoggerFactory.getLogger(ExcelModelReader.class);
    private GJaxbEffectiveMetaModel mm = null;

    public ExcelModelReader(GJaxbEffectiveMetaModel ... mms) throws Exception {
        this.mm = EffectiveMetaModelHelper.mergeEffectiveMetaModel(Arrays.asList(mms));
        ZipSecureFile.setMinInflateRatio((double)-1.0);
    }

    public Map<String, GJaxbGenericModel> read(File f) throws Exception {
        return this.read(f.toURI().toURL().openStream());
    }

    public Map<String, GJaxbGenericModel> read(InputStream excelFile) throws Exception {
        HashMap<String, GJaxbGenericModel> res = new HashMap<String, GJaxbGenericModel>();
        XSSFWorkbook workbook = new XSSFWorkbook(excelFile);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            this.readSheet(workbook.getSheetAt(i), res);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSheet(Sheet sheet, Map<String, GJaxbGenericModel> res) {
        Optional<GJaxbEffectiveConceptType> metaNode;
        String category = sheet.getSheetName().split(" - ")[0].trim();
        String conceptName = sheet.getSheetName().split(" - ")[1].trim();
        FormulaEvaluator evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (res.get(category) == null) {
            res.put(category, new GJaxbGenericModel());
        }
        if (!(metaNode = this.findMetaNode(conceptName)).isPresent()) return;
        List<GJaxbMetaProperty> orderingMetaProps = this.getOrderingProperties(sheet, metaNode.get());
        LOG.debug("");
        for (Row currentRow : sheet) {
            if (currentRow.getRowNum() <= 1) continue;
            int col = 0;
            GJaxbNode node = new GJaxbNode();
            node.setType(metaNode.get().getType());
            boolean emptyLine = false;
            for (GJaxbMetaProperty metaProp : orderingMetaProps) {
                Cell currentCell = currentRow.getCell(col);
                try {
                    if (metaProp.getName().toLowerCase().equals("id")) {
                        String id = null;
                        if (currentCell.getCellTypeEnum() == CellType.FORMULA) {
                            CellValue cellValue = evaluator.evaluate(currentCell);
                            if (cellValue.getStringValue().trim().isEmpty()) {
                                emptyLine = true;
                                break;
                            }
                            id = cellValue.getStringValue();
                        } else {
                            id = this.readCell(currentCell).toString();
                            if (id == null || id.trim().isEmpty()) {
                                emptyLine = true;
                                break;
                            }
                        }
                        node.setId(id);
                    } else if (metaProp.getName().toLowerCase().equals("latitude")) {
                        if (metaNode.get().getNodeMetaGeolocation().isSetPoint()) {
                            this.createOrGetPoint(this.createOrGetGeolocalisation(node)).setLatitude(Double.valueOf(currentCell.getNumericCellValue()));
                        } else {
                            if (!metaNode.get().getNodeMetaGeolocation().isSetPredefinedShape()) throw new UncheckedException("Not implemented !!!");
                            this.createOrGetPredefinedShape(this.createOrGetGeolocalisation(node)).getCircle().getCenter().setLatitude(Double.valueOf(currentCell.getNumericCellValue()));
                        }
                    } else if (metaProp.getName().toLowerCase().equals("longitude")) {
                        if (metaNode.get().getNodeMetaGeolocation().isSetPoint()) {
                            this.createOrGetPoint(this.createOrGetGeolocalisation(node)).setLongitude(Double.valueOf(currentCell.getNumericCellValue()));
                        } else {
                            if (!metaNode.get().getNodeMetaGeolocation().isSetPredefinedShape()) throw new UncheckedException("Not implemented !!!");
                            ((GJaxbNode.Geolocation.ItemView)this.createOrGetGeolocalisation(node).getItemView().get(0)).getPredefinedShape().getCircle().getCenter().setLongitude(Double.valueOf(currentCell.getNumericCellValue()));
                        }
                    } else if (metaProp.getName().toLowerCase().equals("altitude")) {
                        if (metaNode.get().getNodeMetaGeolocation().isSetPoint()) {
                            this.createOrGetPoint(this.createOrGetGeolocalisation(node)).setAltitude(Double.valueOf(currentCell.getNumericCellValue()));
                        } else {
                            if (!metaNode.get().getNodeMetaGeolocation().isSetPredefinedShape()) throw new UncheckedException("Not implemented !!!");
                            ((GJaxbNode.Geolocation.ItemView)this.createOrGetGeolocalisation(node).getItemView().get(0)).getPredefinedShape().getCircle().getCenter().setAltitude(Double.valueOf(currentCell.getNumericCellValue()));
                        }
                    } else {
                        GJaxbProperty prop = this.createPropertyFromMetaProperty(metaProp, currentCell);
                        node.getProperty().add(prop);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.warn("Impossible to read cell correctly: " + String.valueOf(currentCell));
                }
                ++col;
            }
            if (emptyLine) continue;
            res.get(category).getNode().add(node);
        }
    }

    private Object readCell(Cell currentCell) {
        LOG.debug("currentCell = " + String.valueOf(currentCell));
        LOG.debug("currentCell.getCellTypeEnum() = " + String.valueOf(currentCell.getCellTypeEnum()));
        if (currentCell.getCellTypeEnum() == CellType.NUMERIC) {
            return currentCell.getNumericCellValue();
        }
        if (currentCell.getCellTypeEnum() == CellType.FORMULA) {
            LOG.debug("currentCell.getCellFormula() = " + currentCell.getCellFormula());
            return currentCell.getCellFormula();
        }
        return currentCell.getStringCellValue();
    }

    private GJaxbProperty createPropertyFromMetaProperty(GJaxbMetaProperty metaProp, Cell currentCell) {
        GJaxbProperty prop = GenericModelHelper.createProperty((String)metaProp.getName(), null);
        prop.setValue(this.readCell(currentCell).toString());
        return prop;
    }

    private GJaxbNode.Geolocation createOrGetGeolocalisation(GJaxbNode node) {
        if (!node.isSetGeolocation()) {
            node.setGeolocation(new GJaxbNode.Geolocation());
        }
        return node.getGeolocation();
    }

    private GJaxbPointType createOrGetPoint(GJaxbNode.Geolocation geo) {
        if (geo.getItemView().size() == 0) {
            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
            iv.setPoint(new GJaxbPointType());
            geo.getItemView().add(iv);
        }
        return ((GJaxbNode.Geolocation.ItemView)geo.getItemView().get(0)).getPoint();
    }

    private GJaxbPredefinedShape createOrGetPredefinedShape(GJaxbNode.Geolocation geo) {
        if (geo.getItemView().size() == 0) {
            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
            iv.setPredefinedShape(new GJaxbPredefinedShape());
            iv.getPredefinedShape().setCircle(new GJaxbPredefinedShape.Circle());
            iv.getPredefinedShape().getCircle().setCenter(new GJaxbPointType());
            geo.getItemView().add(iv);
        }
        return ((GJaxbNode.Geolocation.ItemView)geo.getItemView().get(0)).getPredefinedShape();
    }

    private List<GJaxbMetaProperty> getOrderingProperties(Sheet sheet, GJaxbEffectiveConceptType metaNode) {
        ArrayList<GJaxbMetaProperty> orderingMetaProps = new ArrayList<GJaxbMetaProperty>();
        int row = 1;
        Row currentRow = sheet.getRow(row);
        for (Cell currentCell : currentRow) {
            String propName = currentCell.getStringCellValue();
            LOG.debug("prop name: " + propName);
            if (propName.toLowerCase().equals("id")) {
                orderingMetaProps.add(MetaModelHelper.createMetaProperty((String)"id", (GJaxbFormtypeType)GJaxbFormtypeType.TEXT, (String)"Node"));
                continue;
            }
            Optional<GJaxbMetaProperty> metaProp = this.findMetaProperty(propName, metaNode);
            if (metaProp.isPresent()) {
                orderingMetaProps.add(metaProp.get());
                continue;
            }
            if (metaNode.isSetNodeMetaGeolocation() && metaNode.getNodeMetaGeolocation().isSetPoint()) {
                if (propName.toLowerCase().equals("latitude")) {
                    orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"latitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                    continue;
                }
                if (propName.toLowerCase().equals("longitude")) {
                    orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"longitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                    continue;
                }
                if (!propName.toLowerCase().equals("altitude")) continue;
                orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"altitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                continue;
            }
            if (metaNode.isSetNodeMetaGeolocation() && metaNode.getNodeMetaGeolocation().isSetPredefinedShape() && metaNode.getNodeMetaGeolocation().getPredefinedShape().isSetCircle()) {
                if (propName.toLowerCase().equals("radius")) {
                    orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"radius", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                    continue;
                }
                if (propName.toLowerCase().equals("latitude")) {
                    orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"latitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                    continue;
                }
                if (propName.toLowerCase().equals("longitude")) {
                    orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"longitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                    continue;
                }
                if (!propName.toLowerCase().equals("altitude")) continue;
                orderingMetaProps.add(MetaModelHelper.createNumberProperty((String)"altitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)));
                continue;
            }
            LOG.warn("Not implemented !!!");
        }
        return orderingMetaProps;
    }

    private Optional<GJaxbMetaProperty> findMetaProperty(String propName, GJaxbEffectiveConceptType metaNode) {
        return metaNode.getMetaProperty().parallelStream().filter(p -> p.getName().equals(propName)).findFirst();
    }

    private Optional<GJaxbEffectiveConceptType> findMetaNode(String sheetName) {
        return this.mm.getEffectiveConcept().parallelStream().filter(n -> n.getType().getLocalPart().equals(sheetName)).findFirst();
    }
}

