/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel;

import fr.emac.gind.commons.utils.excel.ExcelTable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelSheet {
    private Sheet sh = null;
    private SXSSFWorkbook wb = null;
    public static List<HSSFColor.HSSFColorPredefined> LIGHT_COLORS = Arrays.asList(HSSFColor.HSSFColorPredefined.LIGHT_BLUE, HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE, HSSFColor.HSSFColorPredefined.LIGHT_GREEN, HSSFColor.HSSFColorPredefined.LIGHT_ORANGE, HSSFColor.HSSFColorPredefined.LIGHT_TURQUOISE, HSSFColor.HSSFColorPredefined.LIGHT_YELLOW);

    public static HSSFColor.HSSFColorPredefined getRandomLightColor() {
        int randomNum = ThreadLocalRandom.current().nextInt(0, LIGHT_COLORS.size());
        return LIGHT_COLORS.get(randomNum);
    }

    public ExcelSheet(SXSSFWorkbook wb, Sheet sh) {
        this.sh = sh;
        this.wb = wb;
    }

    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    public Sheet getSh() {
        return this.sh;
    }

    public ExcelTable addTable(String name) {
        return new ExcelTable(this.wb, this.sh, name);
    }

    public Cell addCell(Object value, int row, int col) throws Exception {
        Row nextRow = this.getRow(row);
        Cell cell = nextRow.createCell(col);
        ExcelSheet.insertValueIntoCell(this.sh, cell, value, col);
        return cell;
    }

    public Cell addCell(Object value, int row, int col, CellStyle style) throws Exception {
        Cell cell = this.addCell(value, row, col);
        cell.setCellStyle(style);
        return cell;
    }

    public Cell addCell(Object value, int row, int col, int width, int height, CellStyle style) throws Exception {
        Cell firstCell = null;
        for (int i = row; i < row + width; ++i) {
            for (int j = col; j < col + height; ++j) {
                Cell cell = this.addCell("", i, j);
                cell.setCellStyle(style);
                if (i != row || j != col) continue;
                ExcelSheet.insertValueIntoCell(this.sh, cell, value, j);
                firstCell = cell;
            }
        }
        if (width > 2 || height > 2) {
            this.sh.addMergedRegion(new CellRangeAddress(row, row + (width - 1), col, col + (height - 1)));
        }
        return firstCell;
    }

    public Row getRow(int row) {
        Row nextRow = this.sh.getRow(row);
        if (nextRow == null) {
            nextRow = this.sh.createRow(row);
        }
        return nextRow;
    }

    public static void insertValueIntoCell(Sheet sheet, Cell cell, Object value, int currentCol) throws Exception {
        if (value != null) {
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
            } else {
                throw new Exception("Impossible to insert this type of value: " + String.valueOf(value.getClass()));
            }
        }
    }
}

