/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel;

import fr.emac.gind.commons.utils.excel.ExcelSheet;
import fr.emac.gind.commons.utils.excel.helpers.FontHelper;
import fr.emac.gind.commons.utils.excel.helpers.StyleHelper;
import fr.emac.gind.commons.utils.excel.helpers.TableInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelTable {
    private SXSSFWorkbook wb = null;
    private Sheet sheet = null;
    private String name = null;
    private Font titleFont = null;
    private Short headerRowBackgroundColor = HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex();
    private Short headerColBackgroundColor = HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex();
    private Map<Object, Short> valueBackgroundColor = new HashMap<Object, Short>();

    public ExcelTable(SXSSFWorkbook wb, Sheet sheet, String name) {
        this.sheet = sheet;
        this.name = name;
        this.wb = wb;
        this.titleFont = FontHelper.createFont(wb, "IMPACT", (short)14, true, true, HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Short getHeaderRowBackgroundColor() {
        return this.headerRowBackgroundColor;
    }

    public void setHeaderRowBackgroundColor(Short headerRowBackgroundColor) {
        this.headerRowBackgroundColor = headerRowBackgroundColor;
    }

    public Short getHeaderColBackgroundColor() {
        return this.headerColBackgroundColor;
    }

    public void setHeaderColBackgroundColor(Short headerCoolBackgroundColor) {
        this.headerColBackgroundColor = headerCoolBackgroundColor;
    }

    public Map<Object, Short> getValueBackgroundColor() {
        return this.valueBackgroundColor;
    }

    public void addValueBackgroundColor(Object value, Short valueBackgroundColor) {
        this.valueBackgroundColor.put(value, valueBackgroundColor);
    }

    public TableInfo setValue(int indexStartRow, int indexStartCol, List<String> headerColumns, List<String> headerRows, Object[][] val) throws Exception {
        return this.setValue(indexStartRow, indexStartCol, headerColumns, headerRows, val, null);
    }

    public TableInfo setValue(int indexStartRow, int indexStartCol, List<String> headerColumns, List<String> headerRows, Object[][] val, String refTableName) throws Exception {
        ArrayList<Map.Entry<String, List<Object>>> headerColumnsMap = new ArrayList<Map.Entry<String, List<Object>>>();
        ArrayList<Map.Entry<String, List<Object>>> headerRowsMap = new ArrayList<Map.Entry<String, List<Object>>>();
        if (headerColumns != null) {
            headerColumns.forEach(header -> headerColumnsMap.add(new AbstractMap.SimpleEntry<String, Object>((String)header, null)));
        }
        if (headerRows != null) {
            headerRows.forEach(header -> headerRowsMap.add(new AbstractMap.SimpleEntry<String, Object>((String)header, null)));
        }
        return this.setValueUsingComplexHeaders(indexStartRow, indexStartCol, headerColumnsMap, headerRowsMap, val, refTableName);
    }

    public TableInfo setValueUsingComplexHeaders(int indexStartRow, int indexStartCol, List<Map.Entry<String, List<Object>>> headerColumns, List<Map.Entry<String, List<Object>>> headerRows, Object[][] val, String refTableName) throws Exception {
        int currentIndexRow = indexStartRow - 1;
        int currentIndexCol = indexStartCol - 1;
        int width = 0;
        int height = 0;
        Row nextRow = null;
        if (this.name != null) {
            nextRow = this.sheet.getRow(currentIndexRow);
            if (nextRow == null) {
                nextRow = this.sheet.createRow(currentIndexRow);
            }
            CellStyle style = StyleHelper.createCellStyle(this.wb, this.titleFont, null, null);
            Cell cell = nextRow.createCell(currentIndexCol);
            cell.setCellValue(this.name);
            cell.setCellStyle(style);
            currentIndexRow += 2;
            height += 3;
        }
        int depthHeaderRow = this.findDepth(headerRows);
        if (!headerColumns.isEmpty()) {
            nextRow = this.sheet.getRow(currentIndexRow);
            if (nextRow == null) {
                nextRow = this.sheet.createRow(currentIndexRow);
            }
            ++height;
            int currentHeaderIndexCol = currentIndexCol;
            if (!headerRows.isEmpty()) {
                currentHeaderIndexCol = currentIndexCol + depthHeaderRow;
            }
            currentIndexRow = this.generateHeaderColumnsFromMap(headerColumns, nextRow, currentIndexRow, currentHeaderIndexCol);
        }
        if (!headerRows.isEmpty()) {
            int currentHeaderIndexRow = currentIndexRow;
            height = this.generateHeaderRowsFromMap(headerRows, currentIndexCol, height, currentHeaderIndexRow);
            ++width;
        }
        int currentValIndexRow = currentIndexRow;
        int currentValIndexCol = currentIndexCol + depthHeaderRow - 1;
        if (val != null) {
            if (headerRows.size() > 0) {
                ++currentValIndexCol;
            }
            ArrayList<Cell> lastRow = new ArrayList<Cell>();
            ArrayList<Cell> firstCol = new ArrayList<Cell>();
            ArrayList<Cell> lastCol = new ArrayList<Cell>();
            String startCellColRef = null;
            String startCellRowRef = null;
            String endCellColRef = null;
            String endCellRowRef = null;
            int maxWidth = 0;
            int maxHeight = 0;
            for (int i = 0; i < val.length; ++i) {
                if (val.length > maxHeight) {
                    maxHeight = val.length;
                }
                for (int j = 0; j < val[i].length; ++j) {
                    if (val[i].length > maxWidth) {
                        maxWidth = val[i].length;
                    }
                    if ((nextRow = this.sheet.getRow(currentValIndexRow + i)) == null) {
                        nextRow = this.sheet.createRow(currentValIndexRow + i);
                    }
                    if (nextRow == null) continue;
                    Cell cell = nextRow.createCell(currentValIndexCol + j);
                    Object value = val[i][j];
                    Short headerCellBackgroundColor = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
                    if (this.valueBackgroundColor.get(value) != null) {
                        headerCellBackgroundColor = this.valueBackgroundColor.get(value);
                    }
                    CellStyle style = StyleHelper.createCellStyle(this.wb, null, null, headerCellBackgroundColor);
                    cell.setCellStyle(style);
                    StyleHelper.addBorderToStyle(cell.getCellStyle(), null, BorderStyle.THIN, null, BorderStyle.THIN);
                    ExcelSheet.insertValueIntoCell(this.sheet, cell, value, currentValIndexCol + j);
                    if (i == 0 && j == 0) {
                        startCellColRef = CellReference.convertNumToColString((int)cell.getColumnIndex());
                        startCellRowRef = String.valueOf(cell.getRow().getRowNum() + 1);
                    }
                    if (i == val.length - 1) {
                        lastRow.add(cell);
                    }
                    if (j == 0) {
                        firstCol.add(cell);
                    }
                    if (j != val[i].length - 1) continue;
                    lastCol.add(cell);
                    if (i != val.length - 1) continue;
                    endCellColRef = CellReference.convertNumToColString((int)cell.getColumnIndex());
                    endCellRowRef = String.valueOf(cell.getRow().getRowNum() + 1);
                }
                width = maxWidth + 1;
                height = maxHeight + 1;
            }
            if (headerRows.isEmpty()) {
                for (Cell cell : firstCol) {
                    StyleHelper.addBorderToStyle(cell.getCellStyle(), BorderStyle.MEDIUM, null, null, null);
                }
            }
            for (Cell cell : lastRow) {
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, null, null, BorderStyle.MEDIUM);
            }
            for (Cell cell : lastCol) {
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, BorderStyle.MEDIUM, null, null);
            }
            if (refTableName != null) {
                Name reference = this.wb.createName();
                reference.setNameName(refTableName);
                String referenceString = this.sheet.getSheetName() + "!$" + startCellColRef + "$" + startCellRowRef + ":$" + endCellColRef + "$" + endCellRowRef;
                reference.setRefersToFormula(referenceString);
            }
        }
        TableInfo info = new TableInfo(width, height);
        return info;
    }

    private int findDepth(List<Map.Entry<String, List<Object>>> headerRows) {
        int depth = this.findDepthRecursively(headerRows, 0, 0);
        if (depth == 0) {
            depth = 1;
        }
        return depth;
    }

    private int findDepthRecursively(List<Map.Entry<String, List<Object>>> headerRows, int depth, int depthMax) {
        if (!headerRows.isEmpty()) {
            if (depthMax < ++depth) {
                depthMax = depth;
            }
            for (Map.Entry<String, List<Object>> branch : headerRows) {
                if (branch.getValue() == null || !(branch.getValue() instanceof List)) continue;
                return this.findDepthRecursively(branch.getValue(), depth, depthMax);
            }
        }
        return depthMax;
    }

    private int findNumberOfLeafs(List<Map.Entry<String, List<Object>>> headerRows) {
        int leaf = this.findNumberOfLeafsRecursively(headerRows, 0, 0);
        return leaf;
    }

    private int findNumberOfLeafsRecursively(List<Map.Entry<String, List<Object>>> headerRows, int leaf, int leafMax) {
        for (Map.Entry<String, List<Object>> branch : headerRows) {
            if (branch.getValue() != null && !branch.getValue().isEmpty() && branch.getValue() instanceof List) {
                leafMax = this.findNumberOfLeafsRecursively(branch.getValue(), leaf, leafMax);
                continue;
            }
            if (leafMax >= ++leaf) continue;
            leafMax = leaf;
        }
        return leafMax;
    }

    private int generateHeaderRowsFromMap(List<Map.Entry<String, List<Object>>> headerRows, int currentIndexCol, int height, int currentHeaderIndexRow) {
        Row nextRow;
        Cell first = null;
        Cell end = null;
        int startCurrentHeaderIndexRow = currentHeaderIndexRow;
        int startCurrentHeaderIndexCol = currentIndexCol;
        for (Map.Entry<String, List<Object>> header : headerRows) {
            CellStyle style;
            if (header.getValue() == null) {
                style = StyleHelper.createCellStyle(this.wb, null, null, this.headerRowBackgroundColor);
                StyleHelper.addBorderToStyle(style, BorderStyle.MEDIUM, BorderStyle.MEDIUM, null, null);
                nextRow = this.sheet.getRow(currentHeaderIndexRow);
                if (nextRow == null) {
                    nextRow = this.sheet.createRow(currentHeaderIndexRow);
                }
                ++height;
                ++currentHeaderIndexRow;
                Cell cell = nextRow.createCell(currentIndexCol);
                if (((SXSSFSheet)this.sheet).isColumnTrackedForAutoSizing(currentIndexCol)) {
                    this.sheet.autoSizeColumn(currentIndexCol);
                }
                cell.setCellValue(header.getKey());
                cell.setCellStyle(style);
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, null, null, BorderStyle.THIN);
                if (first == null) {
                    first = cell;
                }
                if (!header.equals(headerRows.get(headerRows.size() - 1))) continue;
                end = cell;
                continue;
            }
            style = StyleHelper.createCellStyle(this.wb, null, null, this.headerRowBackgroundColor);
            StyleHelper.addBorderToStyle(style, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
            nextRow = this.sheet.getRow(currentHeaderIndexRow);
            if (nextRow == null) {
                nextRow = this.sheet.createRow(currentHeaderIndexRow);
            }
            int leafs = this.findNumberOfLeafs(headerRows);
            this.sheet.addMergedRegion(new CellRangeAddress(currentHeaderIndexRow, currentHeaderIndexRow + leafs - 1, currentIndexCol, currentIndexCol));
            for (int i = 0; i < leafs; ++i) {
                nextRow = this.sheet.getRow(currentHeaderIndexRow);
                if (nextRow == null) {
                    nextRow = this.sheet.createRow(currentHeaderIndexRow);
                }
                ++currentHeaderIndexRow;
                Cell cell = nextRow.createCell(currentIndexCol);
                this.sheet.autoSizeColumn(currentIndexCol);
                cell.setCellValue(header.getKey());
                cell.setCellStyle(style);
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, null, null, BorderStyle.THIN);
                if (first == null) {
                    first = cell;
                }
                if (!header.equals(headerRows.get(headerRows.size() - 1))) continue;
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, null, null, BorderStyle.MEDIUM);
                end = cell;
            }
            height += leafs;
        }
        ++startCurrentHeaderIndexCol;
        for (Map.Entry<String, List<Object>> header : headerRows) {
            if (header.getValue() == null) continue;
            for (Object h : header.getValue()) {
                if (!(h instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)h;
                CellStyle style = StyleHelper.createCellStyle(this.wb, null, HorizontalAlignment.CENTER, this.headerRowBackgroundColor);
                StyleHelper.addBorderToStyle(style, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
                nextRow = this.sheet.getRow(startCurrentHeaderIndexRow);
                if (nextRow == null) {
                    nextRow = this.sheet.createRow(startCurrentHeaderIndexRow);
                }
                ++startCurrentHeaderIndexRow;
                Cell cell = nextRow.createCell(startCurrentHeaderIndexCol);
                this.sheet.autoSizeColumn(startCurrentHeaderIndexCol);
                cell.setCellValue((String)entry.getKey());
                cell.setCellStyle(style);
                if (first == null) {
                    first = cell;
                }
                if (h != header.getValue().get(header.getValue().size() - 1)) continue;
                end = cell;
            }
        }
        if (first != null) {
            StyleHelper.addBorderToStyle(first.getCellStyle(), BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM, null);
        }
        if (end != null) {
            StyleHelper.addBorderToStyle(end.getCellStyle(), BorderStyle.MEDIUM, BorderStyle.MEDIUM, null, BorderStyle.MEDIUM);
        }
        return height;
    }

    private int generateHeaderColumnsFromMap(List<Map.Entry<String, List<Object>>> headerColumns, Row initialRow, int initialHeaderIndexRow, int initialHeaderIndexCol) {
        Cell first = null;
        Cell end = null;
        int shift = 0;
        int lastRow = initialHeaderIndexRow;
        for (Map.Entry<String, List<Object>> header : headerColumns) {
            Row nextRow = initialRow;
            int currentHeaderIndexRow = initialHeaderIndexRow;
            int currentHeaderIndexCol = initialHeaderIndexCol + shift;
            ++shift;
            if (header.getValue() == null) {
                CellStyle style = StyleHelper.createCellStyle(this.wb, null, HorizontalAlignment.CENTER, this.headerColBackgroundColor);
                StyleHelper.addBorderToStyle(style, null, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
                Cell cell = nextRow.createCell(currentHeaderIndexCol);
                if (((SXSSFSheet)this.sheet).isColumnTrackedForAutoSizing(currentHeaderIndexCol)) {
                    this.sheet.autoSizeColumn(currentHeaderIndexCol);
                }
                ++currentHeaderIndexCol;
                cell.setCellValue(header.getKey());
                cell.setCellStyle(style);
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, BorderStyle.THIN, null, null);
                if (first == null) {
                    first = cell;
                }
                if (!header.equals(headerColumns.get(headerColumns.size() - 1))) continue;
                end = cell;
                continue;
            }
            for (int col = 0; col < header.getValue().size(); ++col) {
                CellStyle style = StyleHelper.createCellStyle(this.wb, null, HorizontalAlignment.CENTER, this.headerColBackgroundColor);
                StyleHelper.addBorderToStyle(style, null, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
                Cell cell = nextRow.createCell(currentHeaderIndexCol + col);
                this.sheet.autoSizeColumn(currentHeaderIndexCol + col);
                cell.setCellValue(header.getKey());
                cell.setCellStyle(style);
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, BorderStyle.THIN, null, null);
                if (first == null) {
                    first = cell;
                }
                if (col != header.getValue().size() - 1) continue;
                end = cell;
            }
            if (first != null) {
                StyleHelper.addBorderToStyle(first.getCellStyle(), BorderStyle.MEDIUM, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
            }
            if (end != null) {
                StyleHelper.addBorderToStyle(end.getCellStyle(), null, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
            }
            if (header.getValue().size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(currentHeaderIndexRow, currentHeaderIndexRow, currentHeaderIndexCol, currentHeaderIndexCol + header.getValue().size() - 1));
            }
            if ((nextRow = this.sheet.getRow(++currentHeaderIndexRow)) == null) {
                nextRow = this.sheet.createRow(currentHeaderIndexRow);
            }
            first = null;
            end = null;
            for (Object h : header.getValue()) {
                CellStyle style = StyleHelper.createCellStyle(this.wb, null, HorizontalAlignment.CENTER, this.headerColBackgroundColor);
                StyleHelper.addBorderToStyle(style, null, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
                Cell cell = nextRow.createCell(currentHeaderIndexCol);
                this.sheet.autoSizeColumn(currentHeaderIndexCol);
                ++currentHeaderIndexCol;
                cell.setCellValue(h.toString());
                cell.setCellStyle(style);
                StyleHelper.addBorderToStyle(cell.getCellStyle(), null, BorderStyle.THIN, null, null);
                if (first == null) {
                    first = cell;
                }
                if (h != header.getValue().get(header.getValue().size() - 1)) continue;
                end = cell;
            }
            if (first != null) {
                StyleHelper.addBorderToStyle(first.getCellStyle(), BorderStyle.MEDIUM, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
            }
            if (end != null) {
                StyleHelper.addBorderToStyle(end.getCellStyle(), null, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
            }
            if (headerColumns.size() > 1 && header.getValue() != null && header.getValue().size() == 1 && header.getValue().get(0).toString().trim().isEmpty()) {
                this.sheet.addMergedRegion(new CellRangeAddress(currentHeaderIndexRow - 1, currentHeaderIndexRow, currentHeaderIndexCol - 1, currentHeaderIndexCol - 1));
                this.sheet.autoSizeColumn(currentHeaderIndexCol - 1);
            }
            currentHeaderIndexCol += header.getValue().size();
            lastRow = currentHeaderIndexRow;
        }
        if (first != null) {
            StyleHelper.addBorderToStyle(first.getCellStyle(), BorderStyle.MEDIUM, null, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
        }
        if (end != null) {
            StyleHelper.addBorderToStyle(end.getCellStyle(), null, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
        }
        return ++lastRow;
    }
}

