/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel.helpers;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class StyleHelper {
    public static CellStyle createCellStyle(SXSSFWorkbook wb, Font font, HorizontalAlignment alignement, Short backgroundColor) {
        CellStyle style = wb.createCellStyle();
        if (font != null) {
            style.setFont(font);
        }
        if (alignement != null) {
            style.setAlignment(alignement);
        }
        if (backgroundColor != null) {
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(backgroundColor.shortValue());
        }
        return style;
    }

    public static CellStyle createCellStyle(SXSSFWorkbook wb, Font font, HorizontalAlignment alignement, Short backgroundColor, BorderStyle left, BorderStyle right, BorderStyle top, BorderStyle bottom) {
        CellStyle style = wb.createCellStyle();
        if (font != null) {
            style.setFont(font);
        }
        if (alignement != null) {
            style.setAlignment(alignement);
        }
        if (backgroundColor != null) {
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(backgroundColor.shortValue());
        }
        StyleHelper.addBorderToStyle(style, left, right, top, bottom);
        return style;
    }

    public static void addBorderToStyle(CellStyle style, BorderStyle left, BorderStyle right, BorderStyle top, BorderStyle bottom) {
        if (left != null) {
            style.setBorderLeft(left);
        }
        if (right != null) {
            style.setBorderRight(right);
        }
        if (top != null) {
            style.setBorderTop(top);
        }
        if (bottom != null) {
            style.setBorderBottom(bottom);
        }
    }
}

