/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel;

import fr.emac.gind.commons.utils.excel.ExcelProjectManager;
import fr.emac.gind.commons.utils.excel.ExcelSheet;
import fr.emac.gind.commons.utils.excel.helpers.FormatCellHelper;
import fr.emac.gind.commons.utils.excel.helpers.StyleHelper;
import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbFormtypeType;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.modeler.metamodel.ObjectFactory;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelModelWriter {
    private static Logger LOG = LoggerFactory.getLogger(ExcelModelWriter.class);
    private static ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private GJaxbEffectiveMetaModel mm = null;
    private List<GJaxbEffectiveMetaModel> mms = null;
    private ExcelProjectManager epm = null;
    private static int DEFAULT_ROW_SIZE = 30;
    private FormatCellHelper fch = null;

    public ExcelModelWriter(GJaxbEffectiveMetaModel ... mms) throws Exception {
        this.mms = Arrays.asList(mms);
        this.mm = EffectiveMetaModelHelper.mergeEffectiveMetaModel(this.mms);
        this.epm = new ExcelProjectManager();
        this.fch = new FormatCellHelper(this.epm.getWb());
    }

    private void generate(GJaxbGenericModel ... models) throws Exception {
        ArrayList nodesAlreadyDone = new ArrayList();
        for (GJaxbEffectiveMetaModel effM : this.mms) {
            effM.getEffectiveConcept().stream().forEach(n -> {
                try {
                    if (!nodesAlreadyDone.contains(n.getType())) {
                        List<GJaxbNode> instances = this.findAllInstance((GJaxbEffectiveConceptType)n, Arrays.asList(models));
                        ExcelSheet sheet = this.createSheet(effM.getName(), (GJaxbEffectiveConceptType)n, instances.size() + DEFAULT_ROW_SIZE);
                        this.addData(sheet, 2, instances, (GJaxbEffectiveConceptType)n);
                        nodesAlreadyDone.add(n.getType());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addData(ExcelSheet sheet, int rowIndex, List<GJaxbNode> instances, GJaxbEffectiveConceptType n) {
        List<Map.Entry<String, List<GJaxbMetaProperty>>> orderingCat = this.generatHeaders(n);
        int row = rowIndex;
        int col = 0;
        for (GJaxbNode node : instances) {
            col = 0;
            for (Map.Entry<String, List<GJaxbMetaProperty>> entry : orderingCat) {
                for (GJaxbMetaProperty metaProp : entry.getValue()) {
                    if (metaProp.getName().equals("id")) {
                        sheet.getSh().getRow(row).getCell(col).setCellFormula(null);
                        sheet.getSh().getRow(row).getCell(col).setCellType(CellType.STRING);
                        sheet.getSh().getRow(row).getCell(col).setCellValue(node.getId());
                    } else {
                        for (GJaxbProperty prop : node.getProperty()) {
                            if (!prop.getName().equals(metaProp.getName())) continue;
                            LOG.debug("set prop '" + metaProp.getName() + "' on col: " + col);
                            sheet.getSh().getRow(row).getCell(col).setCellValue(prop.getValue());
                            break;
                        }
                    }
                    sheet.getSh().autoSizeColumn(col);
                    ++col;
                }
            }
            if (node.isSetGeolocation() && node.getGeolocation().getItemView().size() > 0) {
                if (((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetPoint()) {
                    sheet.getSh().getRow(row).getCell(col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint().getLatitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    sheet.getSh().getRow(row).getCell(++col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint().getLongitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    sheet.getSh().getRow(row).getCell(++col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint().getAltitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    ++col;
                } else {
                    if (!((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetPredefinedShape()) throw new UncheckedException("Not Implemented !!!");
                    if (!((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().isSetCircle()) throw new UncheckedException("Not Implemented !!!");
                    sheet.getSh().getRow(row).getCell(col).setCellValue((double)((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getCircle().getRadius());
                    sheet.getSh().autoSizeColumn(col);
                    sheet.getSh().getRow(row).getCell(++col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLatitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    sheet.getSh().getRow(row).getCell(++col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLongitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    sheet.getSh().getRow(row).getCell(++col).setCellValue(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getAltitude().doubleValue());
                    sheet.getSh().autoSizeColumn(col);
                    ++col;
                }
            }
            ++row;
        }
    }

    private List<GJaxbNode> findAllInstance(GJaxbEffectiveConceptType n, List<GJaxbGenericModel> models) {
        HashMap<String, GJaxbNode> mapInstances = new HashMap<String, GJaxbNode>();
        for (GJaxbGenericModel model : models) {
            for (GJaxbNode node : model.getNode()) {
                if (!node.getType().equals(n.getType())) continue;
                mapInstances.put(node.getId(), node);
            }
        }
        return new ArrayList<GJaxbNode>(mapInstances.values());
    }

    private ExcelSheet createSheet(String category, GJaxbEffectiveConceptType n, int numberOfRows) throws Exception {
        ExcelSheet sheet = this.epm.addSheet(category + " - " + n.getType().getLocalPart());
        sheet.getSh().protectSheet("");
        this.generateTable(n, sheet, numberOfRows);
        return sheet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateTable(GJaxbEffectiveConceptType n, ExcelSheet sheet, int numberOfRows) throws Exception {
        int rowAfterHeader;
        int row = 0;
        int col = 0;
        CellStyle categoryHeaderStyle = StyleHelper.createCellStyle(this.epm.getWb(), null, HorizontalAlignment.CENTER, HSSFColor.HSSFColorPredefined.AQUA.getIndex(), BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
        CellStyle propertyHeaderStyle = StyleHelper.createCellStyle(this.epm.getWb(), null, HorizontalAlignment.CENTER, HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.MEDIUM);
        List<Map.Entry<String, List<GJaxbMetaProperty>>> orderingCat = this.generatHeaders(n);
        for (Map.Entry<String, List<GJaxbMetaProperty>> entry : orderingCat) {
            if (entry.getValue().size() > 1) {
                sheet.addCell(entry.getKey(), row, col, 1, entry.getValue().size(), categoryHeaderStyle);
            } else {
                sheet.addCell(entry.getKey(), row, col, categoryHeaderStyle);
            }
            col += entry.getValue().size();
        }
        if (n.isSetNodeMetaGeolocation()) {
            if (n.getNodeMetaGeolocation().isSetPoint()) {
                sheet.addCell("Geolocalization", row, col, 1, 3, categoryHeaderStyle);
                col += 3;
            } else if (n.getNodeMetaGeolocation().isSetPredefinedShape()) {
                if (n.getNodeMetaGeolocation().getPredefinedShape().isSetCircle()) {
                    sheet.addCell("Geolocalization", row, col, 1, 4, categoryHeaderStyle);
                    col += 3;
                } else {
                    LOG.warn("This kind of geolocalization is not defined !!!");
                }
            } else {
                LOG.warn("This kind of geolocalization is not defined !!!");
            }
        }
        ++row;
        col = 0;
        for (Map.Entry<String, List<GJaxbMetaProperty>> entry : orderingCat) {
            for (GJaxbMetaProperty prop : entry.getValue()) {
                sheet.addCell(prop.getName(), row, col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                ++col;
            }
        }
        if (n.isSetNodeMetaGeolocation()) {
            if (n.getNodeMetaGeolocation().isSetPoint()) {
                sheet.addCell("Latitude", row, col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                sheet.addCell("Longitude", row, ++col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                sheet.addCell("Altitude", row, ++col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                ++col;
            } else {
                if (!n.getNodeMetaGeolocation().isSetPredefinedShape()) throw new UncheckedException("This kind of geolocalization is not defined !!!");
                if (!n.getNodeMetaGeolocation().getPredefinedShape().isSetCircle()) throw new UncheckedException("This kind of geolocalization is not defined !!!");
                sheet.addCell("Radius", row, col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                sheet.addCell("Latitude", row, ++col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                sheet.addCell("Longitude", row, ++col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                sheet.addCell("Altitude", row, ++col, propertyHeaderStyle);
                ((SXSSFSheet)sheet.getSh()).trackColumnForAutoSizing(col);
                sheet.getSh().autoSizeColumn(col);
                ++col;
            }
        }
        int colSize = col;
        for (int i = rowAfterHeader = row + 1; i < rowAfterHeader + numberOfRows; ++i) {
            for (int j = 0; j < colSize; ++j) {
                sheet.addCell(null, i, j, this.getAndCloneFineBorderStyle()).getCellStyle().setLocked(false);
            }
        }
        CellStyle bottomBorderHeaderStyle = StyleHelper.createCellStyle(this.epm.getWb(), null, HorizontalAlignment.LEFT, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), BorderStyle.NONE, BorderStyle.NONE, BorderStyle.MEDIUM, BorderStyle.NONE);
        for (int j = 0; j < colSize; ++j) {
            sheet.addCell(null, rowAfterHeader + numberOfRows, j, bottomBorderHeaderStyle);
        }
        this.formatCellule(n, sheet, orderingCat, rowAfterHeader, numberOfRows);
        sheet.getSh().createFreezePane(0, 1);
        sheet.getSh().createFreezePane(0, 2);
    }

    private List<Map.Entry<String, List<GJaxbMetaProperty>>> generatHeaders(GJaxbEffectiveConceptType n) {
        String categoryWithName = null;
        HashMap<String, List> mapCat = new HashMap<String, List>();
        for (GJaxbMetaProperty prop : n.getMetaProperty()) {
            String category;
            String string = category = prop.isSetCategory() ? prop.getCategory() : "Default Information";
            if (mapCat.get(category) == null) {
                mapCat.put(category, new ArrayList());
            }
            if (prop.getName().toLowerCase().equals("name")) {
                ((List)mapCat.get(category)).add(0, prop);
                categoryWithName = category;
                continue;
            }
            ((List)mapCat.get(category)).add(prop);
        }
        ArrayList<Map.Entry<String, List<GJaxbMetaProperty>>> orderingCat = new ArrayList<Map.Entry<String, List<GJaxbMetaProperty>>>();
        if (categoryWithName != null) {
            List firstProperties = (List)mapCat.remove(categoryWithName);
            orderingCat.add(0, new AbstractMap.SimpleEntry<Object, List>(categoryWithName, firstProperties));
        }
        mapCat.forEach((key, value) -> orderingCat.add(new AbstractMap.SimpleEntry<String, List>((String)key, (List)value)));
        orderingCat.add(0, new AbstractMap.SimpleEntry<String, List<GJaxbMetaProperty>>("Node", Arrays.asList(MetaModelHelper.createMetaProperty((String)"id", (GJaxbFormtypeType)GJaxbFormtypeType.TEXT, (String)"Node"))));
        return orderingCat;
    }

    private void formatCellule(GJaxbEffectiveConceptType n, ExcelSheet sheet, List<Map.Entry<String, List<GJaxbMetaProperty>>> orderingCat, int rowStart, int numberOfRows) throws Exception {
        for (int i = rowStart; i < rowStart + numberOfRows; ++i) {
            int col = 0;
            for (Map.Entry<String, List<GJaxbMetaProperty>> entry : orderingCat) {
                for (GJaxbMetaProperty prop : entry.getValue()) {
                    Cell cell = sheet.getRow(i).getCell(col);
                    this.formatCell(sheet, prop, cell);
                    ++col;
                }
            }
            if (!n.isSetNodeMetaGeolocation()) continue;
            if (n.getNodeMetaGeolocation().isSetPoint()) {
                Cell cellLat = sheet.getRow(i).getCell(col);
                this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"latitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellLat);
                Cell cellLng = sheet.getRow(i).getCell(++col);
                this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"longitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellLng);
                Cell cellAlt = sheet.getRow(i).getCell(++col);
                this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"altitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellAlt);
                ++col;
                continue;
            }
            if (n.getNodeMetaGeolocation().isSetPredefinedShape()) {
                if (n.getNodeMetaGeolocation().getPredefinedShape().isSetCircle()) {
                    Cell cellRadius = sheet.getRow(i).getCell(col);
                    this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"radius", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellRadius);
                    Cell cellLat = sheet.getRow(i).getCell(++col);
                    this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"latitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellLat);
                    Cell cellLng = sheet.getRow(i).getCell(++col);
                    this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"longitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellLng);
                    Cell cellAlt = sheet.getRow(i).getCell(++col);
                    this.formatCell(sheet, MetaModelHelper.createNumberProperty((String)"altitude", (String)"geolocalization", (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0E-5f)), cellAlt);
                    continue;
                }
                throw new UncheckedException("This kind of geolocalization is not defined !!!");
            }
            throw new UncheckedException("This kind of geolocalization is not defined !!!");
        }
    }

    private CellStyle getAndCloneFineBorderStyle() {
        CellStyle fineBorderHeaderStyle = StyleHelper.createCellStyle(this.epm.getWb(), null, HorizontalAlignment.LEFT, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), BorderStyle.MEDIUM, BorderStyle.MEDIUM, BorderStyle.NONE, BorderStyle.NONE);
        return fineBorderHeaderStyle;
    }

    private void formatCell(ExcelSheet sheet, GJaxbMetaProperty prop, Cell cell) throws Exception {
        if (GJaxbFormtypeType.CHECKBOX.equals((Object)prop.getType())) {
            this.fch.formatCheckboxCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.COLOR.equals((Object)prop.getType())) {
            this.fch.formatColorCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.DATE.equals((Object)prop.getType())) {
            this.fch.formatDateCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.DATETIME_LOCAL.equals((Object)prop.getType())) {
            this.fch.formatDateTimeLocalCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.EMAIL.equals((Object)prop.getType())) {
            this.fch.formatEmailCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.FILE.equals((Object)prop.getType())) {
            this.fch.formatFileCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.NUMBER.equals((Object)prop.getType())) {
            this.fch.formatNumberCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.PASSWORD.equals((Object)prop.getType())) {
            this.fch.formatPasswordCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.RADIO.equals((Object)prop.getType())) {
            this.fch.formatRadioCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.TABLE.equals((Object)prop.getType())) {
            this.fch.formatTableCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.TEXT.equals((Object)prop.getType())) {
            this.fch.formatTextCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.TEXTAREA.equals((Object)prop.getType())) {
            this.fch.formatTextAreaCell(sheet.getSh(), cell, prop);
        } else if (GJaxbFormtypeType.TIME.equals((Object)prop.getType())) {
            this.fch.formatTimeCell(sheet.getSh(), cell, prop);
        }
    }

    public ByteArrayOutputStream writeInByteArray(GJaxbGenericModel ... models) throws Exception {
        this.generate(models);
        return this.epm.writeInByteArray();
    }

    public void write(File outputFile, GJaxbGenericModel ... models) throws Exception {
        this.generate(models);
        this.epm.write(outputFile);
    }
}

