/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.excel.helpers;

import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.formula.eval.FunctionEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatCellHelper {
    private static Logger LOG = LoggerFactory.getLogger(FormatCellHelper.class);
    private SXSSFWorkbook wb = null;

    public FormatCellHelper(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public void formatCheckboxCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
    }

    public void formatColorCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
    }

    public void formatDateCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        throw new Exception("Not Implemented !!!");
    }

    public void formatDateTimeLocalCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        LOG.debug("prop " + prop.getName() + " is a date");
        CreationHelper createHelper = this.wb.getCreationHelper();
        cell.getCellStyle().setDataFormat(createHelper.createDataFormat().getFormat("YYYY-MM-dd HH:mm:ss"));
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint dvConstraint = dvHelper.createDateConstraint(6, "" + DateUtil.getExcelDate((Date)sdf.parse("1900-01-01 00:00:00")), null, "");
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
        DataValidation validation = dvHelper.createValidation(dvConstraint, addressList);
        validation.createErrorBox("Error on date value", "Date format is: YYYY-MM-dd HH:mm:ss");
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    public void formatEmailCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        throw new Exception("Not Implemented !!!");
    }

    public void formatFileCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
    }

    public void formatNumberCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        LOG.debug("prop " + prop.getName() + " is a number");
        cell.getCellStyle().setAlignment(HorizontalAlignment.RIGHT);
        int type = 1;
        if (prop.isSetDecimal()) {
            type = 2;
        }
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        if (prop.isSetDecimal()) {
            CreationHelper createHelper = this.wb.getCreationHelper();
            String format = String.format("%f", Float.valueOf(prop.getDecimal())).replace("0", "#").replace("1", "#").replace(",", ".");
            LOG.debug("prop.getDecimal(): " + prop.getDecimal());
            LOG.debug("String.valueOf(prop.getDecimal()): " + String.valueOf(prop.getDecimal()));
            LOG.debug("format: " + format);
            cell.getCellStyle().setDataFormat(createHelper.createDataFormat().getFormat(format));
        }
        if (prop.isSetMin() || prop.isSetMax()) {
            DataValidation validation;
            CellRangeAddressList addressList;
            DataValidationConstraint dvConstraint;
            if (prop.isSetMin()) {
                dvConstraint = dvHelper.createNumericConstraint(type, 6, String.valueOf(prop.getMin()), null);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
                validation = dvHelper.createValidation(dvConstraint, addressList);
                validation.createErrorBox("Error on numerical value", "Value must be greater or equal to " + prop.getMin());
                validation.setShowErrorBox(true);
                sheet.addValidationData(validation);
            }
            if (prop.isSetMax()) {
                dvConstraint = dvHelper.createNumericConstraint(type, 7, String.valueOf(prop.getMax()), null);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
                validation = dvHelper.createValidation(dvConstraint, addressList);
                validation.createErrorBox("Error on numerical value", "Value must be less or equal to " + prop.getMin());
                validation.setShowErrorBox(true);
                sheet.addValidationData(validation);
            }
        }
    }

    public void formatPasswordCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        throw new Exception("Not Implemented !!!");
    }

    public void formatRadioCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        LOG.warn("Not Implemented !!!");
    }

    public void formatTableCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        if (prop.isSetObjectModel() && MetaModelHelper.findMetaProperty((String)"uncertainlyMode", (List)prop.getObjectModel().getMetaProperty()) != null) {
            GJaxbMetaProperty gJaxbMetaProperty = MetaModelHelper.findMetaProperty((String)"value", (List)prop.getObjectModel().getMetaProperty());
        }
    }

    public void formatTextCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        if (prop.getName().equals("id")) {
            cell.getCellStyle().setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
            cell.getCellStyle().setLocked(true);
            cell.setCellType(CellType.FORMULA);
            cell.setCellFormula("IF(COUNTIF(B" + (cell.getRowIndex() + 1) + ":Z" + (cell.getRowIndex() + 1) + ", \"*\") > 0,\"node_excel_" + UUID.randomUUID().toString() + "\", \"\")");
            LOG.debug("supp fnct: " + String.valueOf(FunctionEval.getSupportedFunctionNames()));
            LOG.debug("not supp fnct: " + String.valueOf(FunctionEval.getNotSupportedFunctionNames()));
            LOG.debug("f = " + cell.getCellFormula());
            LOG.debug("");
            sheet.setColumnWidth(cell.getColumnIndex(), 10000);
            sheet.setColumnWidth(cell.getColumnIndex() + 1, 10000);
        }
        if (prop.isSetValues() && prop.getValues().isSetFixedValues()) {
            LOG.debug("prop " + prop.getName() + " as fixed values: " + String.valueOf(prop.getValues().getFixedValues().getValue()));
            DataValidationHelper dvHelper = sheet.getDataValidationHelper();
            List<String> values = prop.getValues().getFixedValues().getValue().stream().map(v -> v.getContent()).collect(Collectors.toList());
            String[] array = values.toArray(new String[values.size()]);
            DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(array);
            CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
            DataValidation dataValidation = dvHelper.createValidation(dvConstraint, addressList);
            sheet.addValidationData(dataValidation);
        }
    }

    public void formatTextAreaCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
    }

    public void formatTimeCell(Sheet sheet, Cell cell, GJaxbMetaProperty prop) throws Exception {
        throw new Exception("Not Implemented !!!");
    }
}

