/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher.utils;

import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.utils.Locker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemExitHook
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger((String)SystemExitHook.class.getName());
    private Locker locker;
    private AbstractLauncher launcher;
    public static boolean systemexist = false;
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public SystemExitHook(Locker locker, AbstractLauncher launcher) {
        this.locker = locker;
        this.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            this.launcher.stopRunner();
            this.scheduledExecutor.shutdownNow();
            Date date = new Date(System.currentTimeMillis());
            LOG.info(this.launcher.getName() + " is properly stopped - " + sdf.format(date));
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            Date date = new Date(System.currentTimeMillis());
            LOG.error(this.launcher.getName() + " is not properly stopped - " + sdf.format(date) + ": " + e.getMessage());
        }
        finally {
            if (this.locker.isLocked()) {
                this.locker.unlock();
            }
            if (systemexist) {
                Runtime.getRuntime().exit(0);
            }
        }
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }
}

