/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher.tasks;

import fr.emac.gind.launcher.AbstractLauncher;
import java.util.List;

public abstract class AbstractTask {
    private String name;
    private String shortcut;
    private String description;
    protected AbstractLauncher launcher;

    public AbstractLauncher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(AbstractLauncher launcher) {
        this.launcher = launcher;
    }

    public void process(List<String> args) throws Exception {
        if (!this.validateArgs(args)) {
            throw new Exception("Bad arguments : " + String.valueOf(args) + " (type 'h' for help)");
        }
        this.doProcess(args);
    }

    protected abstract void doProcess(List<String> var1) throws Exception;

    public boolean validateArgs(List<String> args) {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public String toString() {
        String prefix = this.shortcut + ", " + this.name;
        Object blank = "";
        int length = 25 - prefix.length();
        for (int i = 0; i < length; ++i) {
            blank = (String)blank + " ";
        }
        return prefix + (String)blank + this.description;
    }
}

