/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.yaml;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.launcher.Configuration;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YMLConfigGenerator {
    private static Logger LOG = LoggerFactory.getLogger((String)YMLConfigGenerator.class.getName());

    public static URL generate(Configuration conf, String dwName) throws Exception {
        File confRepo = new File("../conf").getCanonicalFile();
        URL confYMLTemplate = Thread.currentThread().getContextClassLoader().getResource("conf/configYML-template.yml");
        File confYMLTemplateFile = new File(confRepo, "configYML-template.yml");
        if (confYMLTemplateFile.exists()) {
            confYMLTemplate = confYMLTemplateFile.toURI().toURL();
        }
        String buffer = FileUtil.getContents((InputStream)confYMLTemplate.openStream());
        buffer = buffer.replace("${applicationPort}", String.valueOf(conf.getPort()));
        buffer = buffer.replace("${adminPort}", String.valueOf(conf.getPort() + 1));
        LOG.debug("URL CONFIG: " + String.valueOf(conf.getUrl()));
        File yml = null;
        if (conf.getUrl().toURI().toString().startsWith("jar:")) {
            yml = new File("./target/" + dwName + "-config.yml");
        } else {
            File configParent = new File(conf.getUrl().toURI());
            yml = new File(configParent.getParent(), "config.yml");
        }
        if (!yml.exists()) {
            yml.createNewFile();
        }
        FileUtil.setContents((File)yml, (String)buffer);
        LOG.info("YML File created: " + String.valueOf(yml));
        LOG.trace("YML File content: " + buffer);
        return yml.getCanonicalFile().toURI().toURL();
    }
}

