/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher.utils;

import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.tasks.AbstractTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandReader {
    private static Logger LOG = LoggerFactory.getLogger((String)CommandReader.class.getName());
    protected File currentPath;
    private ServiceLoader<AbstractTask> tasksLoader = ServiceLoader.load(AbstractTask.class);
    private SortedMap<String, AbstractTask> map = new TreeMap<String, AbstractTask>();
    private AbstractLauncher launcher;
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public CommandReader(AbstractLauncher launcher) {
        this.launcher = launcher;
        this.map.clear();
        this.tasksLoader.reload();
        for (AbstractTask command : this.tasksLoader) {
            LOG.debug("Load task: " + String.valueOf(command.getClass()));
            command.setLauncher(launcher);
            this.map.put(command.getShortcut(), command);
        }
    }

    public void read() {
        while (this.launcher.isStarted()) {
            try {
                System.out.print(this.launcher.getPromptName() + "@localhost:/> ");
                this.processCommandLine(this.br.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void processCommandLine(String command) {
        if (command != null && command.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(command, " ");
            ArrayList<String> args = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                args.add(tokenizer.nextToken());
            }
            String key = (String)args.get(0);
            if ("h".equalsIgnoreCase(key) || "help".equalsIgnoreCase(key)) {
                this.printUsage();
            } else {
                AbstractTask task = this.getTask(key);
                if (task == null) {
                    if (!this.launcher.interpret(command)) {
                        // empty if block
                    }
                } else {
                    List arguments = null;
                    arguments = args.size() > 1 ? args.subList(1, args.size()) : new ArrayList(0);
                    try {
                        task.process(arguments);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void printUsage() {
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            AbstractTask abstractTask = (AbstractTask)this.map.get(iter.next());
        }
    }

    public AbstractTask getTask(String command) {
        String shortcut;
        AbstractTask task = (AbstractTask)this.map.get(command);
        if (task == null && (shortcut = this.getShortcutFromCommand(command)) != null) {
            task = (AbstractTask)this.map.get(shortcut);
        }
        return task;
    }

    public Map<String, AbstractTask> getTasks() {
        return this.map;
    }

    private String getShortcutFromCommand(String command) {
        String result = null;
        boolean found = false;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext() && !found) {
            AbstractTask task = (AbstractTask)this.map.get(iter.next());
            if (!command.equals(task.getName())) continue;
            result = task.getShortcut();
            found = true;
        }
        return result;
    }
}

