/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller.query;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.AbstractManager;
import fr.emac.gind.marshaller.query.XQueryExpressionException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JaxbXQueryEvaluator {
    private static Logger LOG = LoggerFactory.getLogger((String)JaxbXQueryEvaluator.class.getName());
    private final Configuration configuration = new Configuration();

    public <X extends AbstractJaxbObject> X selectJaxbObjectNode(AbstractJaxbObject jaxbParent, String xqueryString, Class<X> resultInterfaceClass, NamespaceContext context, AbstractManager<?> manager) throws XQueryExpressionException {
        LOG.debug(String.format("Executing XQuery query '%s'.", xqueryString));
        try {
            StaticQueryContext staticQueryContext = this.configuration.newStaticQueryContext();
            XQueryExpression exp = staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            Node contextNode = jaxbParent.getDOMNode();
            DocumentInfo contextItem = this.configuration.buildDocument((Source)new DOMSource(contextNode));
            dynamicContext.setContextItem((Item)contextItem);
            Object result = exp.evaluateSingle(dynamicContext);
            if (result == null) {
                LOG.debug(String.format("Executed XQuery query successfully. 0 node found.", new Object[0]));
                return null;
            }
            AbstractJaxbObject xon = (AbstractJaxbObject)((Node)result).getUserData("jaxb");
            if (!resultInterfaceClass.isInstance(xon)) {
                throw new UncheckedException(String.format("XQuery expression '%s' does not select a single '%s' XML object node.", xqueryString, resultInterfaceClass.getName()));
            }
            LOG.debug(String.format("Executed XQuery expression successfully. 1 node found.", new Object[0]));
            return (X)((AbstractJaxbObject)resultInterfaceClass.cast(xon));
        }
        catch (XPathException xpe) {
            throw new XQueryExpressionException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
    }

    public <X extends AbstractJaxbObject> X[] selectJaxbObjectNodes(AbstractJaxbObject jaxbParent, String xqueryString, Class<X> resultInterfaceClass, NamespaceContext context, AbstractManager<?> manager) throws XQueryExpressionException {
        LOG.debug(String.format("Executing XQuery query '%s'.", xqueryString));
        ArrayList<AbstractJaxbObject> listResult = new ArrayList<AbstractJaxbObject>();
        try {
            StaticQueryContext staticQueryContext = this.configuration.newStaticQueryContext();
            XQueryExpression exp = staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            Node contextNode = jaxbParent.getDOMNode();
            DocumentInfo contextItem = this.configuration.buildDocument((Source)new DOMSource(contextNode));
            dynamicContext.setContextItem((Item)contextItem);
            List result = exp.evaluate(dynamicContext);
            for (Object item : result) {
                AbstractJaxbObject xon = (AbstractJaxbObject)((Node)item).getUserData("jaxb");
                if (!resultInterfaceClass.isInstance(xon)) {
                    throw new UncheckedException(String.format("XQuery expression '%s' does not select '%s' XML object nodes.", xqueryString, resultInterfaceClass.getName()));
                }
                listResult.add((AbstractJaxbObject)resultInterfaceClass.cast(xon));
            }
        }
        catch (XPathException xpe) {
            throw new XQueryExpressionException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
        LOG.debug(String.format("Executed XQuery query successfully. '%s' node(s) found.", listResult.size()));
        return listResult.toArray((AbstractJaxbObject[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }

    public List<?> evaluate(AbstractJaxbObject jaxbParent, String xqueryString) throws XQueryExpressionException {
        LOG.debug(String.format("Executing XQuery query '%s'.", xqueryString));
        try {
            StaticQueryContext staticQueryContext = this.configuration.newStaticQueryContext();
            XQueryExpression exp = staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            Node contextNode = jaxbParent.getDOMNode();
            DocumentInfo contextItem = this.configuration.buildDocument((Source)new DOMSource(contextNode));
            dynamicContext.setContextItem((Item)contextItem);
            List result = exp.evaluate(dynamicContext);
            LOG.debug(String.format("Executed XQuery expression successfully.", new Object[0]));
            return result;
        }
        catch (XPathException xpe) {
            throw new XQueryExpressionException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
    }
}

