/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;

public final class Catalog {
    private static Catalog INSTANCE;
    private CatalogManager catalogManager = null;
    private List<File> catalogFiles = new ArrayList<File>();
    private final Map<String, URI> resolvedUriCache = new HashMap<String, URI>();

    public static Catalog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Catalog();
        }
        return INSTANCE;
    }

    public static void setInstance(Catalog instance) {
        INSTANCE = instance;
    }

    private void resetCatalogManager() {
        this.catalogManager = null;
        this.resolvedUriCache.clear();
    }

    private CatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new CatalogManager();
            this.catalogManager.setUseStaticCatalog(false);
            this.catalogManager.setIgnoreMissingProperties(true);
            StringBuffer sb = new StringBuffer();
            for (File catalogFile : this.catalogFiles) {
                sb.append(catalogFile.getAbsolutePath());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.catalogManager.setCatalogFiles(sb.toString());
        }
        return this.catalogManager;
    }

    public void addCatalogFile(File catalogFile) {
        this.catalogFiles.add(catalogFile);
        this.resetCatalogManager();
    }

    public EntityResolver newEntityResolver() {
        return new CatalogResolver(this.getCatalogManager());
    }

    public URI resolveUri(URI uri) {
        assert (uri != null);
        return this.resolveUri(String.valueOf(uri));
    }

    public URI resolveUri(String uri) {
        assert (uri != null);
        if (this.resolvedUriCache.containsKey(uri)) {
            return this.resolvedUriCache.get(uri);
        }
        try {
            String resolvedUri = this.getCatalogManager().getCatalog().resolveURI(uri);
            URI result = null;
            if (resolvedUri != null) {
                result = URI.create(resolvedUri);
            }
            this.resolvedUriCache.put(uri, result);
            return result;
        }
        catch (MalformedURLException e) {
            throw new UncheckedException(String.format("Cannot resolve URI '%s' (MalformedURLException).", uri));
        }
        catch (IOException e) {
            throw new UncheckedException(String.format("Cannot resolve URI '%s' (IOException).", uri));
        }
    }
}

