/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.source.SourceHelper;
import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.AbstractManager;
import fr.emac.gind.marshaller.Catalog;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JaxbObjectAdopter {
    private URIResolver resolver = null;
    private AbstractManager<?> manager = null;

    public JaxbObjectAdopter(URIResolver resolver, AbstractManager<?> manager) {
        this.resolver = resolver;
        this.manager = manager;
    }

    public boolean isAlreadyAdopted(AbstractJaxbObject parentAdopter, String publicId, String systemId) {
        URI resolvedUri = null;
        try {
            if (publicId != null) {
                resolvedUri = Catalog.getInstance().resolveUri(publicId);
            }
            if (resolvedUri == null) {
                URI baseURI;
                URI newUri;
                if (systemId == null) {
                    systemId = publicId;
                }
                if ((newUri = URIHelper.resolve((URI)(baseURI = parentAdopter.getBaseURI()), (String)systemId)) == null) {
                    if (baseURI != null && !baseURI.isAbsolute()) {
                        baseURI = null;
                        newUri = URI.create(systemId);
                    } else {
                        throw new UncheckedException(String.format("Problem to resolve Uri. Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId, systemId, String.valueOf(baseURI)));
                    }
                }
                if ((resolvedUri = Catalog.getInstance().resolveUri(newUri)) == null) {
                    resolvedUri = newUri;
                }
                assert (resolvedUri != null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UncheckedException(e.getMessage());
        }
        return this.manager.getChild(resolvedUri) != null;
    }

    public AbstractJaxbObject adoptChild(AbstractJaxbObject parentAdopter, String publicId, String systemId, Class<? extends AbstractJaxbObject> resultInterfaceClass) {
        assert (parentAdopter != null);
        Source s = null;
        URI resolvedUri = null;
        try {
            if (publicId != null && (resolvedUri = Catalog.getInstance().resolveUri(publicId)) != null) {
                s = new SAXSource(new InputSource(resolvedUri.toURL().openStream()));
            }
            if (resolvedUri == null) {
                URI baseURI;
                URI newUri;
                if (systemId == null) {
                    systemId = publicId;
                }
                if ((newUri = URIHelper.resolve((URI)(baseURI = parentAdopter.getBaseURI()), (String)systemId)) == null) {
                    if (baseURI != null && !baseURI.isAbsolute()) {
                        baseURI = null;
                        newUri = URI.create(systemId);
                    } else {
                        throw new UncheckedException(String.format("Problem to resolve Uri. Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId, systemId, String.valueOf(baseURI)));
                    }
                }
                if ((resolvedUri = Catalog.getInstance().resolveUri(newUri)) == null) {
                    resolvedUri = newUri;
                }
                assert (resolvedUri != null);
                String base = null;
                if (baseURI != null) {
                    base = baseURI.toString();
                }
                if ((s = this.resolver.resolve(resolvedUri.toString(), base)) == null) {
                    throw new UncheckedException(String.format("Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s' => resolvedUri='%s' ", publicId, systemId, base, resolvedUri.toString()));
                }
            }
        }
        catch (MalformedURLException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (IOException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new UncheckedException(e.getMessage());
        }
        InputSource is = null;
        if (s != null) {
            is = SourceHelper.sourceToInputSource(s, (String)publicId, (String)resolvedUri.toString());
            return this.adoptChild(parentAdopter, is, resolvedUri, resultInterfaceClass);
        }
        throw new UncheckedException(String.format("Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId, systemId, String.valueOf(parentAdopter.getBaseURI())));
    }

    private synchronized AbstractJaxbObject adoptChild(AbstractJaxbObject adoptiveParent, InputSource s, URI sourceUri, Class<? extends AbstractJaxbObject> resultInterfaceClass) {
        AbstractJaxbObject childToAdopt;
        assert (adoptiveParent != null);
        assert (sourceUri != null);
        if (this.manager.getChild(sourceUri) != null) {
            return this.manager.getChild(sourceUri);
        }
        URI baseURI = adoptiveParent.getBaseURI();
        if (baseURI == null && s == null) {
            throw new UncheckedException("Cannot adopt child because adoptive parent has no base URI and sourceUri is not absolute: " + String.valueOf(sourceUri));
        }
        try {
            Class<AbstractJaxbObject> specificInterfaceClass;
            Document doc = DOMUtil.getInstance().parse(s);
            Element root = doc.getDocumentElement();
            Class<? extends AbstractJaxbObject> classFound = resultInterfaceClass;
            if (this.manager.getJaxbSpecificImportResolver() != null && (specificInterfaceClass = this.manager.getJaxbSpecificImportResolver().get(new QName(root.getNamespaceURI(), root.getLocalName()))) != null) {
                classFound = specificInterfaceClass;
            }
            childToAdopt = XMLJAXBContext.getInstance().unmarshallDocument(doc, classFound);
        }
        catch (Exception e) {
            throw new UncheckedException(String.format("Cannot adopt child from URI '%s' (XmlObjectReadException).", sourceUri.toString()), (Throwable)e);
        }
        assert (childToAdopt != null);
        this.manager.addAdoptedChildren(sourceUri, childToAdopt);
        childToAdopt.setAdoptiveParent(adoptiveParent);
        return childToAdopt;
    }
}

