/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller.json;

import fr.emac.gind.commons.utils.json.JSONHelper;
import fr.emac.gind.marshaller.SPIJaxbObjectFactory;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.oxm.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONJAXBContext {
    private static Logger LOG = LoggerFactory.getLogger((String)JSONJAXBContext.class.getName());
    private JAXBContext jsonJaxbContext;
    protected List<Class<?>> currentObjectFactories = new ArrayList();
    protected ServiceLoader<SPIJaxbObjectFactory> objectFactoryLoader = ServiceLoader.load(SPIJaxbObjectFactory.class);
    private static JSONJAXBContext INSTANCE = null;
    private ThreadLocal<Unmarshaller> unmarshaller = new ThreadLocal<Unmarshaller>(this){

        @Override
        protected Unmarshaller initialValue() {
            Unmarshaller unmarshaller = null;
            try {
                unmarshaller = JSONJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
                unmarshaller.setProperty("eclipselink.media-type", (Object)MediaType.APPLICATION_JSON);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return unmarshaller;
        }
    };
    private ThreadLocal<Marshaller> marshaller = new ThreadLocal<Marshaller>(this){

        @Override
        protected Marshaller initialValue() {
            Marshaller marshaller = null;
            try {
                marshaller = JSONJAXBContext.getInstance().getJaxbContext().createMarshaller();
                marshaller.setProperty("eclipselink.media-type", (Object)MediaType.APPLICATION_JSON);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return marshaller;
        }
    };

    private JSONJAXBContext() throws Exception {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("eclipselink.media-type", MediaType.APPLICATION_JSON);
            properties.put("eclipselink.media-type", MediaType.APPLICATION_JSON);
            properties.put("jaxb.encoding", "UTF-8");
            this.currentObjectFactories.clear();
            this.objectFactoryLoader.reload();
            Iterator<SPIJaxbObjectFactory> objectFactoryIterator = this.objectFactoryLoader.iterator();
            while (objectFactoryIterator.hasNext()) {
                try {
                    SPIJaxbObjectFactory command = objectFactoryIterator.next();
                    LOG.debug("Load Object factory: " + String.valueOf(command.getClass()));
                    this.currentObjectFactories.add(command.getClass());
                }
                catch (Throwable e) {
                    LOG.warn(e.getMessage());
                }
            }
            this.jsonJaxbContext = JAXBContextFactory.createContext((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]), properties);
        }
        catch (JAXBException e) {
            throw new Exception(e);
        }
    }

    public static JSONJAXBContext getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new JSONJAXBContext();
        }
        return INSTANCE;
    }

    public synchronized void addOtherObjectFactory(Class<?> ... list) throws Exception {
        if (list != null) {
            for (Class<?> clazz : list) {
                if (this.currentObjectFactories.contains(clazz)) continue;
                this.currentObjectFactories.add(clazz);
            }
            try {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("eclipselink.media-type", MediaType.APPLICATION_JSON);
                properties.put("eclipselink.media-type", MediaType.APPLICATION_JSON);
                properties.put("jaxb.encoding", "UTF-8");
                this.jsonJaxbContext = JAXBContextFactory.createContext((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]), properties);
            }
            catch (JAXBException e) {
                throw new Exception(e);
            }
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jsonJaxbContext;
    }

    public synchronized <T> T unmarshall(String json) throws Exception {
        Object res = null;
        try {
            Object obj = this.unmarshaller.get().unmarshal((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")));
            if (obj instanceof JAXBElement) {
                JAXBElement binding = (JAXBElement)obj;
                res = binding.getValue();
            } else {
                res = obj;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return (T)res;
    }

    public synchronized <T> T unmarshall(String json, Class<T> clazz) throws Exception {
        Object res = null;
        if (json != null) {
            try {
                JAXBElement obj = this.unmarshaller.get().unmarshal((Source)new StreamSource(new ByteArrayInputStream(json.getBytes("UTF-8"))), clazz);
                if (obj instanceof JAXBElement) {
                    JAXBElement binding = obj;
                    res = binding.getValue();
                } else {
                    res = obj;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return (T)res;
    }

    public synchronized <T> T unmarshallWithoutChangeEncoding(String json, Class<T> clazz) throws Exception {
        Object res = null;
        try {
            JAXBElement obj = this.unmarshaller.get().unmarshal((Source)new StreamSource(new ByteArrayInputStream(json.getBytes())), clazz);
            if (obj instanceof JAXBElement) {
                JAXBElement binding = obj;
                res = binding.getValue();
            } else {
                res = obj;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return (T)res;
    }

    public synchronized String marshallAnyElement(Object jaxbElmt) throws Exception {
        return this.marshallAnyElement(jaxbElmt, true);
    }

    public synchronized String marshallAnyElement(Object jaxbElmt, boolean format) throws Exception {
        String res = null;
        if (jaxbElmt != null) {
            try {
                String newRes;
                Marshaller marshall = this.marshaller.get();
                marshall.setProperty("jaxb.formatted.output", (Object)format);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                marshall.marshal(jaxbElmt, (OutputStream)output);
                res = output.toString("UTF-8");
                if (res.contains("\":") && JSONHelper.isJSONValid((String)(newRes = res.replaceAll("([^/])'", "$1//\"").replaceAll("////'", "'")))) {
                    res = newRes;
                }
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
        }
        return res;
    }
}

