/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller.query;

import fr.emac.gind.marshaller.query.NS;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class QueryNamespaceContext
implements NamespaceContext {
    private Map<URI, List<String>> mapns = new HashMap<URI, List<String>>();
    private Map<String, URI> mapprefixes = new HashMap<String, URI>();
    private NamespaceContext resolver = null;

    public QueryNamespaceContext(NS ... nss) {
        for (NS ns : nss) {
            List<String> prefixes = this.mapns.get(ns.getUri());
            if (prefixes == null) {
                prefixes = new ArrayList<String>();
                this.mapns.put(ns.getUri(), prefixes);
            }
            prefixes.add(ns.getPrefix());
            this.mapprefixes.put(ns.getPrefix(), ns.getUri());
        }
    }

    public QueryNamespaceContext(NamespaceContext resolver, NS ... nss) {
        this(nss);
        this.resolver = resolver;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        URI uri = this.mapprefixes.get(prefix);
        if (uri != null) {
            return uri.toString();
        }
        if (this.resolver != null) {
            return this.resolver.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        List<String> prefixes = this.mapns.get(URI.create(namespaceURI));
        if (prefixes != null && !prefixes.isEmpty()) {
            return prefixes.get(0);
        }
        if (this.resolver != null) {
            return this.resolver.getPrefix(namespaceURI);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        List<String> prefixes = this.mapns.get(URI.create(namespaceURI));
        if (prefixes != null && !prefixes.isEmpty()) {
            return prefixes.iterator();
        }
        if (this.resolver != null) {
            return this.resolver.getPrefixes(namespaceURI);
        }
        return null;
    }

    public Iterator<String> iteratePrefixes() {
        ArrayList prefixes = new ArrayList();
        return this.mapprefixes.keySet().iterator();
    }
}

