/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.generic.process.layout;

import fr.emac.gind.commons.generic.process.layout.Cell;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grid {
    private static Logger LOG = LoggerFactory.getLogger(Grid.class);
    private List<List<Cell>> grid = new ArrayList<List<Cell>>();
    private int rowNumber = 0;
    private int colNumber = 0;

    public void insertRow(int row) {
        int newRow = row - 1;
        if (newRow > this.grid.size()) {
            for (int r = this.grid.size(); r < newRow; ++r) {
                this.grid.add(r, new ArrayList());
            }
        }
        this.grid.add(newRow, new ArrayList());
        ++this.rowNumber;
    }

    public void addCell(Cell cell, int row, int col) {
        List<Cell> column;
        int newRow = row - 1;
        int newCol = col - 1;
        if (newRow >= this.grid.size()) {
            for (int r = this.grid.size(); r < newRow; ++r) {
                this.grid.add(r, new ArrayList());
            }
            this.grid.add(newRow, new ArrayList());
        }
        if (newCol > (column = this.grid.get(newRow)).size()) {
            for (int c = column.size(); c < newCol; ++c) {
                column.add(c, null);
            }
        }
        if (newCol < column.size()) {
            column.set(newCol, cell);
        } else {
            column.add(newCol, cell);
        }
        if (row > this.rowNumber) {
            this.rowNumber = row;
        }
        if (col > this.colNumber) {
            this.colNumber = col;
        }
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void normalize() {
        this.removeEmptyLines();
        for (int row = 0; row < this.rowNumber; ++row) {
            List<Cell> column = this.grid.get(row);
            if (column.size() >= this.colNumber) continue;
            for (int c = column.size(); c < this.colNumber; ++c) {
                column.add(c, null);
            }
        }
        this.removeEmptyColumns();
    }

    public void removeEmptyColumns() {
        for (int j = 1; j <= this.getColNumber(); ++j) {
            boolean empty = true;
            for (int i = 1; i <= this.getRowNumber(); ++i) {
                if (this.getCell(i, j) == null || this.getCell(i, j).getNode() == null) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            LOG.debug("removing column " + (j - 1));
            this.removeColmun(j - 1);
        }
    }

    public void setPositionOfCells(float stepX, float stepY) {
        this.normalize();
        float x = stepX / 2.0f;
        float y = stepY / 2.0f;
        for (int row = 0; row < this.rowNumber; ++row) {
            List<Cell> column = this.grid.get(row);
            x = stepX / 2.0f;
            for (int col = 0; col < this.colNumber; ++col) {
                Cell c = column.get(col);
                if (c != null) {
                    c.setPosition(x, y);
                }
                x += stepX;
            }
            y += stepY;
        }
    }

    public String print() {
        Object buffer = "";
        this.normalize();
        for (int col = 0; col < this.colNumber; ++col) {
            buffer = (String)buffer + "-------";
        }
        buffer = (String)buffer + "\n";
        for (int row = 0; row < this.rowNumber; ++row) {
            int col;
            List<Cell> column = this.grid.get(row);
            for (col = 0; col < this.colNumber; ++col) {
                buffer = (String)buffer + "| ";
                buffer = column.get(col) != null ? (String)buffer + column.get(col).print() : (String)buffer + "   ";
                buffer = (String)buffer + " |";
            }
            buffer = (String)buffer + "\n";
            for (col = 0; col < this.colNumber; ++col) {
                buffer = (String)buffer + "-------";
            }
            buffer = (String)buffer + "\n";
        }
        return buffer;
    }

    public Cell getCell(int i, int j) {
        List<Cell> row;
        if (--i >= 0 && i < this.grid.size() && (row = this.grid.get(i)) != null && --j >= 0 && j < row.size()) {
            return row.get(j);
        }
        return null;
    }

    private void removeEmptyLines() {
        ArrayList<List<Cell>> emptyLines = new ArrayList<List<Cell>>();
        for (List<Cell> row : this.grid) {
            if (!row.isEmpty() && !this.allIsNull(row)) continue;
            emptyLines.add(row);
        }
        this.rowNumber -= emptyLines.size();
        for (List<Cell> emptyLine : emptyLines) {
            this.grid.remove(emptyLine);
        }
    }

    private boolean allIsNull(List<Cell> row) {
        for (Cell col : row) {
            if (col == null) continue;
            return false;
        }
        return true;
    }

    public Cell findCellContaining(GJaxbNode endEvent) {
        for (int row = 0; row < this.rowNumber; ++row) {
            List<Cell> column = this.grid.get(row);
            for (Cell cell : column) {
                if (cell == null || cell.getNode() != endEvent) continue;
                return cell;
            }
        }
        return null;
    }

    public int getColumnIndex(Cell cell) {
        for (int row = 0; row < this.rowNumber; ++row) {
            List<Cell> column = this.grid.get(row);
            for (int col = 0; col < this.colNumber; ++col) {
                if (this.colNumber >= column.size() || column.get(col) != cell) continue;
                return col;
            }
        }
        return -1;
    }

    public int getRowIndex(Cell cell) {
        for (int row = 0; row < this.rowNumber; ++row) {
            List<Cell> column = this.grid.get(row);
            for (int col = 0; col < this.colNumber; ++col) {
                if (this.colNumber >= column.size() || column.get(col) != cell) continue;
                return row;
            }
        }
        return -1;
    }

    public List<List<Cell>> getGrid() {
        return this.grid;
    }

    public void removeColmun(int j) {
        for (int i = 0; i < this.getGrid().size(); ++i) {
            List<Cell> currentRow = this.getGrid().get(i);
            for (int jj = j; jj < this.getColNumber() - 1; ++jj) {
                Cell shift = currentRow.get(jj + 1);
                currentRow.set(jj, shift);
            }
        }
        --this.colNumber;
    }
}

