/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.generic.process.layout;

import fr.emac.gind.commons.generic.process.layout.Cell;
import fr.emac.gind.commons.generic.process.layout.Grid;
import fr.emac.gind.modeler.genericmodel.GJaxbBreakpoint;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.models.generic.modeler.utils.ModelingHelper;
import fr.emac.gind.rio.PluginCollaborativeModel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLayout {
    private static Logger LOG = LoggerFactory.getLogger((String)ProcessLayout.class.getName());
    private GJaxbGenericModel processModel = null;
    private GenericModelManager manager = null;
    private final float stepX = 200.0f;
    private final float stepY = 100.0f;
    private Map<String, Grid> grids = new HashMap<String, Grid>();
    private GJaxbEffectiveMetaModel mm = null;
    private EffectiveMetaModelManager mmm = null;

    public ProcessLayout(GJaxbGenericModel process, GJaxbEffectiveMetaModel mm) throws Exception {
        this.processModel = process;
        this.manager = new GenericModelManager(new GJaxbGenericModel[]{this.processModel});
        this.mm = mm;
        this.mmm = new EffectiveMetaModelManager(new GJaxbEffectiveMetaModel[]{this.mm});
    }

    public void organize() throws Exception {
        for (GJaxbNode n : this.processModel.getNode()) {
            GJaxbNode parent = GenericModelHelper.findFirstParent((GJaxbNode)n, (GJaxbGenericModel)this.processModel);
            String parentId = parent != null ? parent.getId() : null;
            this.organize(parentId);
        }
    }

    private void organize(String parentId) throws Exception {
        if (this.grids.get(parentId) == null) {
            Object cell;
            Grid g = new Grid();
            this.grids.put(parentId, g);
            ArrayList<GJaxbNode> nodeToPlaced = new ArrayList<GJaxbNode>();
            ArrayList<GJaxbNode> startEvents = new ArrayList<GJaxbNode>();
            ArrayList<GJaxbNode> endEvents = new ArrayList<GJaxbNode>();
            for (GJaxbNode node : this.processModel.getNode()) {
                GJaxbNode parent = GenericModelHelper.findFirstParent((GJaxbNode)node, (GJaxbGenericModel)this.processModel);
                if (parentId == null && parent == null) {
                    nodeToPlaced.add(node);
                } else if (parent != null && parentId != null && parent.getId().equals(parentId)) {
                    nodeToPlaced.add(node);
                }
                if (!nodeToPlaced.contains(node)) continue;
                if (node.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Start_Event"))) {
                    startEvents.add(node);
                }
                if (!node.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "End_Event"))) continue;
                endEvents.add(node);
            }
            for (GJaxbNode st : startEvents) {
                this.placeNodeInCorrespondingCell(g, st, 1, 1, null, new ArrayList<GJaxbNode>());
                if (!endEvents.isEmpty()) {
                    GJaxbNode endEvent = (GJaxbNode)endEvents.get(0);
                    cell = g.findCellContaining(endEvent);
                    int col = g.getColumnIndex((Cell)cell);
                    int row = g.getRowIndex((Cell)cell);
                    if (col <= 0) {
                        if (cell != null) {
                            ((Cell)cell).setNode(null);
                        }
                        g.addCell(new Cell(endEvent), g.getRowNumber() / 2 + 1, g.getColNumber() + 1);
                    }
                }
                g.setPositionOfCells(200.0f, 100.0f);
            }
            for (GJaxbNode n : nodeToPlaced) {
                if (!this.manager.findEdgesOfNode(n).isEmpty()) continue;
                GJaxbNode isolatedNode = n;
                block3: for (List<Cell> row : g.getGrid()) {
                    for (Cell c : row) {
                        if (c.getNode() != null) continue;
                        c.setNode(isolatedNode);
                        break block3;
                    }
                }
                if (isolatedNode.getUserData("correspondingCell") != null) continue;
                g.insertRow(g.getGrid().size() + 1);
                cell = new Cell(isolatedNode);
                g.addCell((Cell)cell, g.getGrid().size() + 1, 1);
            }
            g.normalize();
            g.setPositionOfCells(200.0f, 100.0f);
            for (GJaxbEdge e : this.processModel.getEdge()) {
                this.placeEdge(e);
                if (e.getSource() == null || e.getTarget() == null || !e.getSource().getId().equals(e.getTarget().getId())) continue;
                if (!e.isSetModeling()) {
                    e.setModeling(new GJaxbEdge.Modeling());
                }
                GJaxbEdge.Modeling.ItemView ivEdgeProcess = GenericModelHelper.findItemViewFromPackage((GJaxbEdge)e, (String)"process", (boolean)true);
                GJaxbNode.Modeling.ItemView ivSourceProcess = GenericModelHelper.findItemViewFromPackage((GJaxbNode)e.getSource(), (String)"process", (boolean)false);
                GJaxbBreakpoint bp1 = new GJaxbBreakpoint();
                bp1.setX((double)(ivSourceProcess.getPosition().getX() - ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f + ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue()));
                bp1.setY((double)(ivSourceProcess.getPosition().getY() - ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f));
                ivEdgeProcess.getBreakpoint().add(bp1);
                GJaxbBreakpoint bp2 = new GJaxbBreakpoint();
                bp2.setX((double)(ivSourceProcess.getPosition().getX() - ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f));
                bp2.setY((double)(ivSourceProcess.getPosition().getY() - ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f));
                ivEdgeProcess.getBreakpoint().add(bp2);
            }
        }
    }

    private void placeEdge(GJaxbEdge e) throws Exception {
        GJaxbNode.Modeling.ItemView ivSourceProcess;
        GJaxbEdge.Modeling.ItemView ivEdgeProcess = GenericModelHelper.findItemViewFromPackage((GJaxbEdge)e, (String)"process", (boolean)true);
        if (e.isSetSource()) {
            if (!ivEdgeProcess.isSetSourcePosition()) {
                ivEdgeProcess.setSourcePosition(new GJaxbEdge.Modeling.ItemView.SourcePosition());
            }
            if (!ivEdgeProcess.getSourcePosition().isSetPosition()) {
                ivEdgeProcess.getSourcePosition().setPosition(new GJaxbPosition());
            }
            if ((ivSourceProcess = GenericModelHelper.findItemViewFromPackage((GJaxbNode)e.getSource(), (String)"process", (boolean)false)).isSetPosition() && ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()) != null && ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()) != null) {
                ivEdgeProcess.getSourcePosition().getPosition().setX(ivSourceProcess.getPosition().getX() + ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() + 5.0f);
                ivEdgeProcess.getSourcePosition().getPosition().setY(ivSourceProcess.getPosition().getY() + ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivSourceProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f);
            }
        }
        if (e.isSetTarget()) {
            if (!ivEdgeProcess.isSetTargetPosition()) {
                ivEdgeProcess.setTargetPosition(new GJaxbEdge.Modeling.ItemView.TargetPosition());
            }
            if (!ivEdgeProcess.getTargetPosition().isSetPosition()) {
                ivEdgeProcess.getTargetPosition().setPosition(new GJaxbPosition());
            }
            ivSourceProcess = GenericModelHelper.findItemViewFromPackage((GJaxbNode)e.getSource(), (String)"process", (boolean)true);
            GJaxbNode.Modeling.ItemView ivTargetProcess = GenericModelHelper.findItemViewFromPackage((GJaxbNode)e.getTarget(), (String)"process", (boolean)false);
            if (ivTargetProcess.isSetPosition() && ModelingHelper.findWidthOfTiemView((GJaxbNode.Modeling.ItemView)ivTargetProcess, (GJaxbNode)e.getSource()) != null && ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivTargetProcess, (GJaxbNode)e.getSource()) != null) {
                ivEdgeProcess.getTargetPosition().getPosition().setX(ivTargetProcess.getPosition().getX() - 5.0f);
                ivEdgeProcess.getTargetPosition().getPosition().setY(ivTargetProcess.getPosition().getY() + ModelingHelper.findHeightOfTiemView((GJaxbNode.Modeling.ItemView)ivTargetProcess, (GJaxbNode)e.getSource()).floatValue() / 2.0f);
            }
        }
    }

    private boolean hasMoreOccurences(List<GJaxbNode> nodes, GJaxbNode node, int maxOccurs) {
        return nodes.stream().filter(n -> n == node).count() > (long)maxOccurs;
    }

    private Map.Entry<Integer, Integer> placeNodeInCorrespondingCell(Grid grid, GJaxbNode currentNode, int currentRow, int currentCol, GJaxbNode untilNode, List<GJaxbNode> nodesAlreadyView) throws Exception {
        Map.Entry<Integer, Integer> lastPosition = null;
        if (currentNode != null && currentNode != untilNode) {
            if (currentNode.getUserData("correspondingCell") == null) {
                grid.addCell(new Cell(currentNode), currentRow, currentCol);
            }
            nodesAlreadyView.add(currentNode);
            List outEdges = this.manager.findOutputEdgesOfNode(currentNode);
            if (outEdges.size() > 1 && !this.hasMoreOccurences(nodesAlreadyView, currentNode, 3)) {
                lastPosition = this.placeInSplit(grid, currentNode, currentRow, ++currentCol, nodesAlreadyView);
            } else if (outEdges.size() == 1 && !this.hasMoreOccurences(nodesAlreadyView, ((GJaxbEdge)outEdges.get(0)).getTarget(), 3)) {
                lastPosition = this.placeNodeInCorrespondingCell(grid, ((GJaxbEdge)outEdges.get(0)).getTarget(), currentRow, ++currentCol, untilNode, nodesAlreadyView);
            }
        }
        if (lastPosition == null) {
            lastPosition = new AbstractMap.SimpleEntry<Integer, Integer>(currentRow, currentCol);
        }
        return lastPosition;
    }

    private Map.Entry<Integer, Integer> placeInSplit(Grid grid, GJaxbNode split, int currentRow, int currentCol, List<GJaxbNode> nodesAlreadyView) throws Exception {
        Map.Entry<Integer, Integer> lastPosition = null;
        if (split != null) {
            int i;
            int maxPathLength = 5;
            List outEdges = this.manager.findOutputEdgesOfNode(split);
            LOG.debug("split: " + String.valueOf(split));
            GJaxbNode join = this.findCorrespondingJoin(split, outEdges.size(), 0, new ArrayList<GJaxbNode>());
            if (join == null) {
                String name = GenericModelHelper.getName((GJaxbNode)split).replaceFirst("input_", "output_");
                List joins = this.manager.getNodesByProperty("name", (Object)name);
                if (joins != null && joins.isEmpty()) {
                    join = (GJaxbNode)joins.get(0);
                }
                LOG.debug("join: " + String.valueOf(join));
                if (join != null && join.getUserData("maxPathLength") != null) {
                    maxPathLength = (Integer)join.getUserData("maxPathLength");
                }
            }
            LOG.debug("maxPathLength: " + maxPathLength);
            int shiftRow = outEdges.size() / 2;
            int newRow = currentRow - shiftRow;
            int numberRowAdd = 0;
            for (i = currentRow - shiftRow; i < currentRow; ++i) {
                boolean addRow = false;
                if (i < 1) {
                    addRow = true;
                } else {
                    for (int j = currentCol; j < currentCol + maxPathLength; ++j) {
                        if (grid.getCell(i, j) == null) continue;
                        addRow = true;
                        break;
                    }
                }
                if (!addRow) continue;
                ++numberRowAdd;
            }
            for (i = 0; i < numberRowAdd; ++i) {
                grid.insertRow(currentRow);
                ++newRow;
            }
            lastPosition = this.placeNodeInCorrespondingCell(grid, join, currentRow + numberRowAdd, currentCol + maxPathLength, null, nodesAlreadyView);
            int indice = 0;
            for (GJaxbEdge outEdge : outEdges) {
                GJaxbNode nextNode = outEdge.getTarget();
                if (indice == shiftRow && outEdges.size() % 2 == 0) {
                    ++newRow;
                }
                lastPosition = this.placeNodeInCorrespondingCell(grid, nextNode, newRow, currentCol, join, nodesAlreadyView);
                newRow = lastPosition.getKey() + 1;
                ++indice;
            }
        }
        return lastPosition;
    }

    private GJaxbNode findCorrespondingJoin(GJaxbNode nodeInSplit, int splitNumber, int pathLength, ArrayList<GJaxbNode> nodesAlreadyView) throws Exception {
        if (pathLength > 0) {
            splitNumber -= this.manager.findInputEdgesOfNode(nodeInSplit).size() - 1;
        }
        if (splitNumber <= 1) {
            if (nodeInSplit.getUserData("maxPathLength") == null) {
                nodeInSplit.setUserData("maxPathLength", (Object)pathLength);
            }
            if ((Integer)nodeInSplit.getUserData("maxPathLength") < pathLength) {
                nodeInSplit.setUserData("maxPathLength", (Object)(pathLength - 1));
            }
            return nodeInSplit;
        }
        ArrayList<GJaxbNode> joins = new ArrayList<GJaxbNode>();
        List outEdges = this.manager.findOutputEdgesOfNode(nodeInSplit);
        for (GJaxbEdge outEdge : outEdges) {
            GJaxbNode nextNode = outEdge.getTarget();
            if (this.hasMoreOccurences(nodesAlreadyView, nextNode, 3)) continue;
            nodesAlreadyView.add(nextNode);
            GJaxbNode join = this.findCorrespondingJoin(nextNode, splitNumber + (this.manager.findOutputEdgesOfNode(nextNode).size() - 1), pathLength + 1, nodesAlreadyView);
            joins.add(join);
        }
        if (!joins.isEmpty()) {
            return (GJaxbNode)joins.get(0);
        }
        return null;
    }

    public String print() {
        Object buffer = "";
        for (Grid g : this.grids.values()) {
            buffer = (String)buffer + g.print() + "\n\n";
        }
        return buffer;
    }

    public static void setSizeOfAllImages(List<GJaxbEffectiveConceptType> nodes) {
        for (GJaxbConceptType gJaxbConceptType : nodes) {
            if (gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView() == null || gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension() == null || gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().isSetHeight() && gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().isSetWidth()) continue;
            String fileName = gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl().trim().substring(gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl().trim().indexOf("/webjars/"));
            try {
                throw new Exception("TODO: Add width (48) and height (48) on only rio models");
            }
            catch (Exception e) {
                LOG.warn("Impossible to get size of svg: META-INF/resources" + gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl().trim() + ". Set default size (width: 60, height: 60)");
                if (gJaxbConceptType.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Abstract_Task")) || gJaxbConceptType.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Scope"))) {
                    gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                    gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
                    continue;
                }
                if (gJaxbConceptType.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Event")) || gJaxbConceptType.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Gateway"))) {
                    gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                    gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
                    continue;
                }
                gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                gJaxbConceptType.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
            }
        }
    }
}

