/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.plugins.python;

import fr.emac.gind.commons.plugins.python.AbstractPythonDjangoServer;
import fr.emac.gind.commons.plugins.python.AbstractPythonExecComponent;
import fr.emac.gind.commons.plugins.python.AbstractPythonModule;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class PythonPluginsManager {
    private ServiceLoader<AbstractPythonModule> moduleLoader = ServiceLoader.load(AbstractPythonModule.class);
    private Map<String, AbstractPythonModule> modules = new HashMap<String, AbstractPythonModule>();
    private ServiceLoader<AbstractPythonExecComponent> execComponentLoader = ServiceLoader.load(AbstractPythonExecComponent.class);
    private Map<String, AbstractPythonExecComponent> execComponents = new HashMap<String, AbstractPythonExecComponent>();
    private ServiceLoader<AbstractPythonDjangoServer> djangoServerLoader = ServiceLoader.load(AbstractPythonDjangoServer.class);
    private Map<String, AbstractPythonDjangoServer> djangoServers = new HashMap<String, AbstractPythonDjangoServer>();
    private static PythonPluginsManager INSTANCE = null;

    private PythonPluginsManager() throws Exception {
        this.initPlugins();
    }

    public static PythonPluginsManager getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new PythonPluginsManager();
        }
        return INSTANCE;
    }

    private void initPlugins() throws Exception {
        this.loadModules();
        this.loadExecComponents();
        this.loadDjangoServers();
    }

    private void loadModules() {
        this.modules.clear();
        this.moduleLoader.reload();
        for (AbstractPythonModule uc : this.moduleLoader) {
            this.modules.put(uc.getArtefactId() + "==" + uc.getPythonVersion(), uc);
        }
    }

    private void loadExecComponents() {
        this.execComponents.clear();
        this.execComponentLoader.reload();
        for (AbstractPythonExecComponent uc : this.execComponentLoader) {
            this.execComponents.put(uc.getArtefactId() + "==" + uc.getPythonVersion(), uc);
            this.modules.put(uc.getArtefactId() + "==" + uc.getPythonVersion(), uc);
        }
    }

    private void loadDjangoServers() {
        this.djangoServers.clear();
        this.djangoServerLoader.reload();
        for (AbstractPythonDjangoServer uc : this.djangoServerLoader) {
            this.djangoServers.put(uc.getArtefactId() + "==" + uc.getPythonVersion(), uc);
            this.modules.put(uc.getArtefactId() + "==" + uc.getPythonVersion(), uc);
        }
    }

    public Map<String, AbstractPythonModule> getModules() {
        return this.modules;
    }

    public Map<String, AbstractPythonExecComponent> getExecComponents() {
        return this.execComponents;
    }

    public Map<String, AbstractPythonDjangoServer> getDjangoServers() {
        return this.djangoServers;
    }
}

