/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.plugins.python;

import fr.emac.gind.commons.plugins.python.AbstractPythonModule;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonExecComponent
extends AbstractPythonModule {
    private static Logger LOG = LoggerFactory.getLogger(AbstractPythonExecComponent.class);
    private ExecutorService service = null;

    public abstract String getPythonFile();

    public abstract List<String> getCommands();

    public void runPythonComponent(final List<String> commands, final List<Process> processToKill) throws Exception {
        this.installInternalDependancies(processToKill);
        LOG.debug("Run manage.py");
        commands.add(0, this.pythonExec);
        LOG.debug(String.valueOf(commands));
        this.service = Executors.newSingleThreadExecutor();
        this.service.execute(new Runnable(){
            final /* synthetic */ AbstractPythonExecComponent this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    String line;
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    processBuilder.command(commands);
                    Process process = processBuilder.inheritIO().start();
                    processToKill.add(process);
                    StringBuilder output = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        output.append(line + "\n");
                    }
                    int exitVal = process.waitFor();
                    reader.close();
                    if (exitVal != 0) {
                        throw new Exception("Error to execute '" + this.this$0.getPythonFile() + "': " + output.toString());
                    }
                    LOG.debug("Success!");
                    LOG.debug(String.valueOf(output));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void stopPythonModule() {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }
}

