/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.plugins.python;

import fr.emac.gind.commons.plugins.python.PythonDependency;
import fr.emac.gind.commons.plugins.python.PythonPluginsManager;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.os.OSValidator;
import fr.emac.gind.launcher.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonModule {
    private Logger LOG = LoggerFactory.getLogger((String)AbstractPythonModule.class.getName());
    public static final String PYTHON_LIBRAIRIES = "../python_librairies/";
    protected Boolean isEmbedded = false;
    protected String pythonExec = "python";

    public abstract String getArtefactId();

    public abstract String getPythonVersion();

    public abstract List<PythonDependency> getInternalDependencies();

    public List<List<String>> getPostPythonCommands() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIsEmbedded(Boolean isEmbedded) throws Exception {
        this.isEmbedded = isEmbedded;
        if (this.isEmbedded.booleanValue()) {
            if (OSValidator.isWindows()) {
                this.pythonExec = new File("../python/windows/").getCanonicalPath() + "/python.exe";
                return;
            } else if (OSValidator.isUnix()) {
                this.pythonExec = new File("../python/linux/").getCanonicalPath() + "/python";
                return;
            } else {
                if (!OSValidator.isMac()) throw new Exception("Os not defined");
                this.pythonExec = new File("../python/macosx/").getCanonicalPath() + "/python";
            }
            return;
        } else {
            this.pythonExec = "python";
        }
    }

    public void installInternalDependancies(List<Process> processToKill) throws Exception {
        ArrayList<PythonDependency> dependencies = new ArrayList<PythonDependency>(this.getInternalDependencies());
        dependencies.add(new PythonDependency(this.getArtefactId(), this.getPythonVersion()));
        for (PythonDependency dep : dependencies) {
            AbstractPythonModule module = PythonPluginsManager.getInstance().getModules().get(dep.getArtefactId() + "==" + dep.getVersion());
            if (module == null) {
                throw new Exception("Impossible to find module: " + dep.getArtefactId() + "==" + dep.getVersion());
            }
            if (!this.isEmbedded.booleanValue()) {
                if (Configuration.MODE.equals((Object)Configuration.ModeType.DEV)) {
                    Object path = new File(".").getCanonicalPath().substring(0, new File(".").getCanonicalPath().indexOf("java" + File.separator));
                    path = module.getArtefactId().equals("gind-python-bootstrap") ? (String)path + "python/bootstrap_python/" : (String)path + "python/backend/";
                    String module_python_version = module.getPythonVersion();
                    if ("1.0-SNAPSHOT".equals(module_python_version)) {
                        module_python_version = "1.0.dev0";
                    }
                    this.LOG.debug("try to install python module: " + dep.getArtefactId() + "==" + module_python_version);
                    this.installModule(module.getArtefactId(), (String)path, this.isEmbedded);
                } else {
                    this.LOG.debug("Download and Extract Zip");
                    this.extractPythonDistribInJar(module, PYTHON_LIBRAIRIES);
                    this.LOG.debug("Install Requirements");
                    this.installRequirements(module, PYTHON_LIBRAIRIES);
                    this.LOG.debug("Install Libs");
                    this.installLib(module, PYTHON_LIBRAIRIES);
                }
            } else {
                this.LOG.info("---------INSTALL PYTHON_LIBRAIRIES -------------: " + String.valueOf(module));
                this.LOG.debug("Download and Extract Zip");
                this.extractPythonDistribInJar(module, PYTHON_LIBRAIRIES);
                this.LOG.debug("Install Requirements");
                this.installRequirements(module, PYTHON_LIBRAIRIES);
                this.LOG.debug("Install Libs");
                this.installLib(module, PYTHON_LIBRAIRIES);
            }
            this.LOG.info("-------------- getArtefactId --------------: " + module.getArtefactId());
            if (module.getPostPythonCommands() == null || module.getPostPythonCommands().size() <= 0) continue;
            for (List<String> command : module.getPostPythonCommands()) {
                this.runPythonCommand(command);
            }
        }
    }

    private void runPythonCommand(List<String> command) throws Exception {
        String line;
        command.add(0, this.pythonExec);
        this.LOG.debug("\tpython> // Try to run command: " + String.valueOf(command));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        this.LOG.debug("\tpython> " + String.valueOf(command));
        Process process = processBuilder.inheritIO().start();
        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.LOG.debug("\tpython> " + line);
            output.append(line + "\n");
        }
        int exitVal = process.waitFor();
        reader.close();
        if (exitVal != 0) {
            throw new Exception(output.toString() + " - exitVal: " + exitVal);
        }
        this.LOG.debug("\tpython> Success!");
    }

    private void installRequirements(AbstractPythonModule module, String targetDirectory) throws Exception {
        String line;
        String module_python_version = module.getPythonVersion();
        if ("1.0-SNAPSHOT".equals(module_python_version)) {
            module_python_version = "1.0.dev0";
        }
        String setupLocationDir = targetDirectory + "/" + module.getArtefactId() + "-" + module_python_version + "/";
        this.LOG.debug("\tpython> // Try to install (Requirements) : " + module.getArtefactId());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(new File(setupLocationDir).getCanonicalFile());
        processBuilder.command(this.pythonExec, "-m", "pip", "install", "-r", "requirements.txt");
        this.LOG.debug("\tpython> " + String.valueOf(new File(setupLocationDir).getCanonicalFile()));
        this.LOG.debug("\tpython> " + this.pythonExec + " -m pip  install -r requirements.txt");
        Process process = processBuilder.inheritIO().start();
        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.LOG.debug("\tpython> " + line);
            output.append(line + "\n");
        }
        int exitVal = process.waitFor();
        reader.close();
        if (exitVal != 0) {
            throw new Exception(output.toString() + " - exitVal: " + exitVal);
        }
        this.LOG.debug("\tpython> Success!");
    }

    private void installLib(AbstractPythonModule module, String targetDirectory) throws Exception {
        String line;
        String module_python_version = module.getPythonVersion();
        if ("1.0-SNAPSHOT".equals(module_python_version)) {
            module_python_version = "1.0.dev0";
        }
        String setupLocationDir = targetDirectory + "/" + module.getArtefactId() + "-" + module_python_version + "/";
        this.LOG.debug("\tpython> // Try to install (Lib) : " + module.getArtefactId());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(new File(setupLocationDir).getCanonicalFile());
        processBuilder.command(this.pythonExec, "setup.py", "install");
        this.LOG.debug("\tpython> " + String.valueOf(new File(setupLocationDir).getCanonicalFile()));
        this.LOG.debug("\tpython> " + this.pythonExec + " setup.py install");
        Process process = processBuilder.inheritIO().start();
        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.LOG.debug("\tpython> " + line);
            output.append(line + "\n");
        }
        int exitVal = process.waitFor();
        reader.close();
        if (exitVal != 0) {
            throw new Exception(output.toString() + " - exitVal: " + exitVal);
        }
        this.LOG.debug("\tpython> Success!");
    }

    private void extractPythonDistribInJar(AbstractPythonModule module, String targetDirectory) throws Exception {
        File dir = new File(targetDirectory);
        dir.mkdirs();
        File zip = new File(dir, module.getArtefactId() + "-" + module.getPythonVersion() + ".zip");
        if (!zip.exists()) {
            String module_python_version = module.getPythonVersion();
            if ("1.0-SNAPSHOT".equals(module_python_version)) {
                module_python_version = "1.0.dev0";
            }
            URL url_link = Thread.currentThread().getContextClassLoader().getResource("dist/" + module.getArtefactId() + "-" + module_python_version + ".zip");
            this.LOG.debug("\tpython> Find to try module: " + String.valueOf(url_link));
            InputStream link = url_link.openStream();
            Files.copy(link, zip.getAbsoluteFile().toPath(), new CopyOption[0]);
            ZipUtil.unZip((ZipFile)new ZipFile(zip), (File)dir);
        }
    }

    private void installModule(String artefactId, String path, Boolean isEmbedded) throws Exception {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(new File(path + artefactId));
        this.LOG.debug("\tpython> // Try to install : " + artefactId);
        if (!isEmbedded.booleanValue()) {
            this.LOG.debug("\tpython> " + String.valueOf(processBuilder.command()));
            processBuilder.command(this.pythonExec, "setup.py", "install");
        } else {
            processBuilder.command(this.pythonExec, "setup.py", "java_bootstrap", "--pexec==" + this.pythonExec, "install");
        }
        this.LOG.debug("\tpython> " + String.valueOf(processBuilder.command()));
        Process process = processBuilder.inheritIO().start();
        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.LOG.debug("\tpython> " + line);
            output.append(line + "\n");
        }
        int exitVal = process.waitFor();
        reader.close();
        if (exitVal != 0) {
            throw new Exception(output.toString());
        }
        this.LOG.debug("\tpython> Success!");
    }

    public void stopPythonModule() {
    }
}

