/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import com.sun.tools.xjc.Driver;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.JavaFileBO;
import fr.emac.gind.rio.utils.plugin.JavaSourceExtractor;
import fr.emac.gind.rio.utils.plugin.XSDImportBO;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Mojo(name="generate-code", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public abstract class AbstractXsdToCodeMojo
extends AbstractMojo {
    @Parameter(property="xsdFiles")
    protected List<File> xsdFiles = new ArrayList<File>();
    @Parameter(property="inputDirectory")
    protected File inputDirectory;

    public void execute() throws MojoExecutionException {
        System.out.println("Start " + this.getMojoName() + "...");
        try {
            if (this.getCodeOutputDirectory() == null) {
                throw new MojoExecutionException("outputDirectory cannot be null !!!");
            }
            if (this.inputDirectory != null) {
                this.xsdFiles.addAll(Arrays.asList(FileUtil.findFilesByExtension((File)this.inputDirectory, (String)"xsd")));
            }
            if (this.xsdFiles == null || this.xsdFiles.isEmpty()) {
                throw new MojoExecutionException("xsdFiles cannot be null or empty !!!");
            }
            File tsOutput = new File(this.getCodeOutputDirectory(), this.getCodeExtensionFileName());
            tsOutput.mkdirs();
            System.out.println("tsOutput: " + String.valueOf(tsOutput));
            System.out.println("xsdFiles: " + String.valueOf(this.xsdFiles));
            File tempJavaDir = new File("./target/", "java-temp/");
            tempJavaDir.mkdirs();
            System.out.println("tempJavaDir: " + String.valueOf(tempJavaDir));
            for (File xsdFile : this.xsdFiles) {
                System.out.println("Analyse " + String.valueOf(xsdFile) + "...");
                String xsdShortName = xsdFile.getName();
                String targetNameSpace = AbstractXsdToCodeMojo.extractTargetNamespace(xsdFile);
                String keyName = targetNameSpace.replace("http://www.gind.emac.fr/", "").replace("/", File.separator);
                if (keyName.endsWith(File.separator)) {
                    keyName = keyName.substring(0, keyName.length() - File.separator.length());
                }
                this.getLog().info((CharSequence)("G\u00e9n\u00e9ration des classes Java depuis " + xsdFile.getPath()));
                Driver.run((String[])new String[]{"-d", tempJavaDir.getAbsolutePath(), xsdFile.getAbsolutePath()}, (PrintStream)System.out, (PrintStream)System.out);
                File[] javaFiles = FileUtil.findFilesByExtension((File)tempJavaDir, (String)"java");
                ArrayList<File> validJavaFiles = new ArrayList<File>();
                ArrayList<String> otherPossiblePackageNames = new ArrayList<String>();
                for (File javaFile : javaFiles) {
                    System.out.println("javaFile: " + String.valueOf(javaFile));
                    System.out.println("keyName: " + keyName);
                    String path = javaFile.getPath();
                    path = path.substring(0, path.lastIndexOf(File.separator));
                    if (path.endsWith(keyName.toLowerCase())) {
                        if (javaFile.getName().contains("package-info") || javaFile.getName().contains("ObjectFactory")) continue;
                        AbstractXsdToCodeMojo.removeJavaDocComments(javaFile);
                        validJavaFiles.add(javaFile);
                        continue;
                    }
                    String content = Files.readString(javaFile.toPath());
                    String otherPackageName = AbstractXsdToCodeMojo.extractPackageName(content);
                    otherPossiblePackageNames.add(otherPackageName);
                }
                System.out.println("All java files : ");
                validJavaFiles.forEach(System.out::println);
                List<XSDImportBO> xsdImports = AbstractXsdToCodeMojo.extractSchemaLocationsFromXsd(xsdFile);
                List<String> tsImports = this.generateImportsFromSchemaLocations(xsdImports);
                String tsFileName = xsdShortName.replace("-", "_").replace(".xsd", "." + this.getCodeExtensionFileName());
                String tsCode = this.convertJavaFilesToCode(validJavaFiles, tsFileName, tsImports, xsdImports, otherPossiblePackageNames);
                Files.writeString(new File(tsOutput, tsFileName).toPath(), (CharSequence)tsCode, new OpenOption[0]);
                this.getLog().info((CharSequence)("Fichier " + this.getCodeExtensionFileName() + " g\u00e9n\u00e9r\u00e9  : " + tsFileName + " dans : " + tsOutput.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Erreur lors de la g\u00e9n\u00e9ration des fichiers", e);
        }
    }

    public String getMojoName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public abstract File getCodeOutputDirectory();

    public abstract String getCodeExtensionFileName();

    public static String extractTargetNamespace(File xsdFile) throws IOException {
        String content = Files.readString(xsdFile.toPath());
        Pattern pattern = Pattern.compile("targetNamespace\\s*=\\s*\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public List<String> generateImportsFromSchemaLocations(List<XSDImportBO> xsdImports) throws Exception {
        ArrayList<String> tsImports = new ArrayList<String>();
        for (XSDImportBO xsdImport : xsdImports) {
            String namespace;
            Object keyWord;
            String location = xsdImport.schemaLocation;
            String fileName = location.substring(location.lastIndexOf("/") + "/".length());
            if (fileName.endsWith(".xsd")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            if (((String)(keyWord = (namespace = xsdImport.namespace).split("/")[namespace.split("/").length - 1].toLowerCase())).equals("data")) {
                keyWord = namespace.split("/")[namespace.split("/").length - 2].toLowerCase() + "_data";
            }
            this.generateCodeImport(tsImports, fileName, (String)keyWord);
        }
        return tsImports;
    }

    protected abstract void generateCodeImport(List<String> var1, String var2, String var3);

    public static List<XSDImportBO> extractSchemaLocationsFromXsd(File xsdFile) throws Exception {
        ArrayList<XSDImportBO> xsdImports = new ArrayList<XSDImportBO>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xsdFile);
        NodeList imports = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < imports.getLength(); ++i) {
            Element importElem = (Element)imports.item(i);
            String location = importElem.getAttribute("schemaLocation");
            String namespace = importElem.getAttribute("namespace");
            if (location.isEmpty()) continue;
            xsdImports.add(new XSDImportBO(namespace, location));
        }
        return xsdImports;
    }

    private static void removeJavaDocComments(File javaFile) throws IOException {
        String content = Files.readString(javaFile.toPath());
        Pattern javadocPattern = Pattern.compile("/\\*\\*.*?\\*/", 32);
        Matcher matcher = javadocPattern.matcher(content);
        String cleaned = matcher.replaceAll("");
        Files.writeString(javaFile.toPath(), (CharSequence)cleaned, new OpenOption[0]);
    }

    public static String extractPackageName(String content) {
        Pattern packagePattern = Pattern.compile("package\\s+([\\w\\.]+);");
        Matcher matcher = packagePattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String convertJavaFilesToCode(List<File> javaFiles, String xsdShortName, List<String> tsImports, List<XSDImportBO> xsdImports, List<String> otherPossiblePackageNames) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (tsImports != null) {
            for (String string : tsImports) {
                sb.append(string + "\n");
            }
        }
        sb.append("\n");
        this.additionalHeaderCode(sb, xsdShortName);
        ArrayList<JavaFileBO> allJavaFileBOs = new ArrayList<JavaFileBO>();
        for (File file : javaFiles) {
            if (file.getName().contains("Edge")) {
                System.out.println("break");
            }
            JavaFileBO javaFileBO = JavaSourceExtractor.extractJavaFileStructure(file);
            allJavaFileBOs.add(javaFileBO);
        }
        ArrayList<ClassBO> arrayList = new ArrayList<ClassBO>();
        for (JavaFileBO javaFileBO : allJavaFileBOs) {
            arrayList.addAll(this.getAllClasses(javaFileBO));
        }
        ArrayList<JavaFileBO> arrayList2 = new ArrayList<JavaFileBO>();
        for (JavaFileBO javaFileBO : allJavaFileBOs) {
            javaFileBO.xsdImports.addAll(xsdImports);
            javaFileBO.otherPossiblePackageNames.addAll(otherPossiblePackageNames);
            for (ClassBO classBO : javaFileBO.mainClasses) {
                if (classBO.className.equals("EffectiveConceptType")) {
                    System.out.println("break");
                }
                if (classBO.parentClassName == null) continue;
                classBO.parentClass = ClassBO.findParentClass(classBO.parentClassName, arrayList);
                if (classBO.parentClass == null) continue;
                arrayList2.add(classBO.parentClass.javaFileBO);
            }
        }
        for (JavaFileBO starterJavaFilBo : arrayList2) {
            allJavaFileBOs.remove(starterJavaFilBo);
            allJavaFileBOs.add(0, starterJavaFilBo);
        }
        for (JavaFileBO javaFileBO : allJavaFileBOs) {
            this.convertJavaToCode(javaFileBO, sb, allJavaFileBOs);
        }
        return sb.toString();
    }

    protected abstract void additionalHeaderCode(StringBuilder var1, String var2);

    private List<ClassBO> getAllClasses(JavaFileBO javaFileBO) {
        ArrayList<ClassBO> allClasses = new ArrayList<ClassBO>();
        for (ClassBO mainClass : javaFileBO.mainClasses) {
            this.getAllInnerClassesRecursively(mainClass, allClasses);
            this.getAllExtendsClassesRecursively(mainClass, allClasses);
            allClasses.add(mainClass);
        }
        return allClasses;
    }

    private void getAllExtendsClassesRecursively(ClassBO mainClass, List<ClassBO> allClasses) {
        if (mainClass.parentClass != null) {
            allClasses.add(mainClass.parentClass);
            this.getAllInnerClassesRecursively(mainClass.parentClass, allClasses);
        }
    }

    private void getAllInnerClassesRecursively(ClassBO mainClass, List<ClassBO> allClasses) {
        for (ClassBO innerClass : mainClass.innerClasses) {
            allClasses.add(innerClass);
            this.getAllInnerClassesRecursively(innerClass, allClasses);
        }
    }

    private void convertJavaToCode(JavaFileBO javaFileBO, StringBuilder ts, List<JavaFileBO> allJavaFileBOs) throws IOException {
        for (EnumBO enum_ : javaFileBO.enums) {
            System.out.println("Convert enum: " + enum_.enumName);
            this.convertEnumToCode(ts, enum_);
        }
        for (ClassBO class_ : javaFileBO.mainClasses) {
            System.out.println("Convert class : " + class_.className);
            this.convertJavaClassToCode(ts, class_);
            class_.alreadyDone = true;
        }
    }

    protected abstract void convertJavaClassToCode(StringBuilder var1, ClassBO var2);

    protected abstract void convertEnumToCode(StringBuilder var1, EnumBO var2);

    protected String sanitizeCodeIdentifier(String id) {
        Object s = id.replaceAll("[^A-Za-z0-9_]", "_");
        if (((String)s).isEmpty() || Character.isDigit(((String)s).charAt(0))) {
            s = "_" + (String)s;
        }
        return s;
    }
}

