/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class FieldBO {
    public String name;
    public String type;
    public List<? extends AnnotationTree> annotations;
    public List<AnnotationBO> annotationBOs;

    public FieldBO() {
    }

    public FieldBO(String name, String type, List<? extends AnnotationTree> anns) {
        this.name = name;
        this.type = type;
        this.annotationBOs = FieldBO.toAnnoDTOs(anns);
    }

    public String getName() {
        String xmlName = this.getXmlElementName();
        if (xmlName != null) {
            return xmlName;
        }
        return this.name;
    }

    private String getXmlElementName() {
        String name;
        AnnotationBO xmlElem = this.hasXmlElementAnnotation();
        if (xmlElem != null && (name = xmlElem.args.get("name")) != null && !name.isBlank() && !(name = name.replace("\"", "").trim()).equals("##default")) {
            return name;
        }
        return null;
    }

    public AnnotationBO hasXmlElementAnnotation() {
        if (this.annotationBOs != null) {
            for (AnnotationBO a : this.annotationBOs) {
                if (!"XmlElement".equals(a.name)) continue;
                return a;
            }
        }
        return null;
    }

    public String hasNampespaceAttributeInXmlElementAnnotation() {
        String namespace;
        AnnotationBO xmlElem = this.hasXmlElementAnnotation();
        if (xmlElem != null && (namespace = xmlElem.args.get("namespace")) != null && !namespace.isBlank()) {
            namespace = namespace.replace("\"", "").trim();
            return namespace;
        }
        return null;
    }

    public String getKeyWordFromNamespaceAttributeInXmlElementAnnotation() {
        String namespace = this.hasNampespaceAttributeInXmlElementAnnotation();
        if (namespace != null) {
            Object keyWord = namespace.replace("\"", "").split("/")[namespace.split("/").length - 1].toLowerCase();
            if (((String)keyWord).equals("data")) {
                keyWord = namespace.replace("\"", "").split("/")[namespace.split("/").length - 2].toLowerCase() + "_data";
            }
            return keyWord;
        }
        return null;
    }

    public String toString() {
        return "FieldBO{name='" + this.name + "', type='" + this.type + "', annotations=" + String.valueOf(this.annotations) + "}";
    }

    public static List<AnnotationBO> toAnnoDTOs(List<? extends AnnotationTree> anns) {
        if (anns == null || anns.isEmpty()) {
            return List.of();
        }
        ArrayList<AnnotationBO> out = new ArrayList<AnnotationBO>(anns.size());
        for (AnnotationTree annotationTree : anns) {
            String sourceName = annotationTree.getAnnotationType().toString();
            String simpleName = sourceName.contains(".") ? sourceName.substring(sourceName.lastIndexOf(46) + 1) : sourceName;
            AnnotationBO dto = new AnnotationBO();
            dto.sourceName = sourceName;
            dto.name = simpleName;
            if (annotationTree.getArguments() != null) {
                for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                    if (expressionTree instanceof AssignmentTree) {
                        AssignmentTree at = (AssignmentTree)expressionTree;
                        String k = at.getVariable().toString();
                        String v = FieldBO.stringifyExpr(at.getExpression());
                        dto.args.put(k, v);
                        continue;
                    }
                    dto.args.put("value", FieldBO.stringifyExpr(expressionTree));
                }
            }
            out.add(dto);
        }
        return out;
    }

    private static String stringifyExpr(ExpressionTree e) {
        if (e == null) {
            return "null";
        }
        if (e instanceof LiteralTree) {
            LiteralTree lit = (LiteralTree)e;
            Object v = lit.getValue();
            if (v == null) {
                return "null";
            }
            if (v instanceof String) {
                String s = (String)v;
                return "\"" + s + "\"";
            }
            if (v instanceof Character) {
                Character c = (Character)v;
                return "'" + c + "'";
            }
            return String.valueOf(v);
        }
        if (e instanceof IdentifierTree) {
            IdentifierTree id = (IdentifierTree)e;
            return id.getName().toString();
        }
        if (e instanceof MemberSelectTree) {
            MemberSelectTree ms = (MemberSelectTree)e;
            return FieldBO.stringifyExpr(ms.getExpression()) + "." + ms.getIdentifier().toString();
        }
        if (e instanceof NewArrayTree) {
            NewArrayTree arr = (NewArrayTree)e;
            List<? extends ExpressionTree> inits = arr.getInitializers();
            if (inits == null || inits.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < inits.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FieldBO.stringifyExpr(inits.get(i)));
            }
            return sb.append("]").toString();
        }
        if (e instanceof AnnotationTree) {
            AnnotationTree anno = (AnnotationTree)e;
            List<AnnotationBO> nested = FieldBO.toAnnoDTOs(List.of(anno));
            return nested.isEmpty() ? e.toString() : "@" + nested.get((int)0).sourceName + String.valueOf(nested.get((int)0).args);
        }
        return e.toString();
    }

    public static final class AnnotationBO {
        public String name;
        public String sourceName;
        public LinkedHashMap<String, String> args = new LinkedHashMap();

        public String toString() {
            return "@" + this.sourceName + (this.args.isEmpty() ? "" : this.args.toString());
        }
    }
}

