/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import fr.emac.gind.rio.utils.plugin.AbstractXsdToCodeMojo;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.FieldBO;
import fr.emac.gind.rio.utils.plugin.JavaSourceExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-ts", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class XsdToTsMojo
extends AbstractXsdToCodeMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/ts")
    protected File outputDirectory;

    @Override
    public String getCodeExtensionFileName() {
        return "ts";
    }

    @Override
    public File getCodeOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void generateCodeImport(List<String> tsImports, String fileName, String keyWord) {
        String tsImport = "import * as " + keyWord + " from './" + fileName.replace("-", "_") + "';";
        tsImports.add(tsImport);
    }

    @Override
    protected void additionalHeaderCode(StringBuilder sb, String xsdShortName) {
    }

    @Override
    protected void convertJavaClassToCode(StringBuilder sb, ClassBO classBO) {
        this.convertJavaClassToTS(sb, classBO);
    }

    @Override
    protected void convertEnumToCode(StringBuilder sb, EnumBO enum_) {
        this.convertEnumToTS(sb, enum_);
    }

    private void convertJavaClassToTS(StringBuilder ts, ClassBO classBO) {
        StringBuilder ifaceBuilder = new StringBuilder();
        String className = classBO.className;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(className)) {
            className = JavaSourceExtractor.mappingForbidenClassNames.get(className);
        }
        String tsParent = null;
        if (classBO.parentClassName != null && !classBO.parentClassName.isBlank()) {
            tsParent = this.parentTsName(classBO.parentClassName);
        }
        this.appendTsInterfaceHeader(ifaceBuilder, this.sanitizeCodeIdentifier(className), tsParent);
        for (Map.Entry<String, FieldBO> fieldEntry : classBO.fields.entrySet()) {
            String tsType = this.mapTypeToTS(fieldEntry.getValue().type, fieldEntry.getValue(), classBO);
            ifaceBuilder.append("  ").append(fieldEntry.getValue().getName()).append("?: ").append(tsType).append(";\n");
        }
        ifaceBuilder.append("\n}\n\n");
        if (classBO.innerClasses != null) {
            for (ClassBO inner : classBO.innerClasses) {
                inner.javaFileBO = classBO.javaFileBO;
                this.convertJavaClassToTS(ts, inner);
            }
        }
        ts.append((CharSequence)ifaceBuilder);
    }

    private String convertEnumToTS(StringBuilder ts, EnumBO enum_) {
        StringBuilder tsEnum = new StringBuilder();
        List<String> lines = Arrays.asList(enum_.enumBlockCode.split("\n"));
        String enumName = null;
        ArrayList<String[]> entries = new ArrayList<String[]>();
        Pattern enumStart = Pattern.compile("enum\\s+(\\w+)");
        Pattern valueEnumPattern = Pattern.compile("^(\\w+)\\s*\\(\\s*\"([^\"]+)\"\\s*\\)\\s*,?;?");
        Pattern simpleEnumPattern = Pattern.compile("^\\s*(\\w+)\\s*,?;?\\s*$");
        for (String raw : lines) {
            String name;
            Matcher simpleMatcher;
            Matcher m;
            String line = raw.trim();
            if (line.startsWith("@")) continue;
            if (enumName == null && (m = enumStart.matcher(line)).find()) {
                enumName = m.group(1);
                continue;
            }
            Matcher valueMatcher = valueEnumPattern.matcher(line);
            if (valueMatcher.find()) {
                String name2 = valueMatcher.group(1);
                String value = valueMatcher.group(2);
                if (name2.equals("value") || name2.equals("fromValue")) continue;
                entries.add(new String[]{name2, value});
                continue;
            }
            if (line.contains("(") || !(simpleMatcher = simpleEnumPattern.matcher(line)).find() || (name = simpleMatcher.group(1)).equals("value") || name.equals("fromValue")) continue;
            entries.add(new String[]{name, null});
        }
        if (enumName == null || enumName.isBlank()) {
            return "";
        }
        tsEnum.append("export enum ").append(enumName).append(" {\n");
        for (int i = 0; i < entries.size(); ++i) {
            String name = ((String[])entries.get(i))[0];
            String val = ((String[])entries.get(i))[1];
            if (val != null) {
                tsEnum.append("  ").append(name).append(" = \"").append(val).append("\"");
            } else {
                tsEnum.append("  ").append(name).append(" = \"").append(name).append("\"");
            }
            if (i < entries.size() - 1) {
                tsEnum.append(",");
            }
            tsEnum.append("\n");
        }
        tsEnum.append("}\n\n");
        tsEnum.append("export function parse").append(enumName).append("(value: string): ").append(enumName).append(" {\n").append("  switch (value) {\n");
        for (String[] e : entries) {
            String name = e[0];
            String val = e[1] != null ? e[1] : e[0];
            tsEnum.append("    case \"").append(val).append("\": return ").append(enumName).append(".").append(name).append(";\n");
        }
        tsEnum.append("    default: throw new Error(\"Invalid ").append(enumName).append(" value: \" + value);\n").append("  }\n").append("}\n\n");
        ts.append((CharSequence)tsEnum);
        return tsEnum.toString();
    }

    private String mapTypeToTS(String javaType, FieldBO fieldBO, ClassBO class_) {
        if (javaType == null || javaType.isBlank()) {
            return "any | null";
        }
        javaType = javaType.replace(class_.javaFileBO.packageName + ".", "");
        for (String otherPackageName : class_.javaFileBO.otherPossiblePackageNames) {
            javaType = javaType.replace(otherPackageName + ".", "");
        }
        Object t = javaType.trim();
        if (((String)t).equals("UncertainlyMode")) {
            System.out.println("break");
        }
        switch (t) {
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "Byte": 
            case "Short": 
            case "Integer": 
            case "BigInteger": 
            case "Long": 
            case "Float": 
            case "Double": 
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.math.BigInteger": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return "number | null";
            }
            case "boolean": 
            case "Boolean": 
            case "java.lang.Boolean": {
                return "boolean | null";
            }
            case "char": 
            case "String": 
            case "QName": 
            case "DataHandler": 
            case "Character": 
            case "java.lang.Character": 
            case "java.lang.String": {
                return "string | null";
            }
            case "LocalDate": 
            case "LocalDateTime": 
            case "Date": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": 
            case "java.util.Date": 
            case "XMLGregorianCalendar": 
            case "javax.xml.datatype.XMLGregorianCalendar": {
                return "string | null";
            }
            case "java.lang.Object": 
            case "Object": {
                return "any | null";
            }
        }
        if (((String)t).startsWith("List<")) {
            String inner = ((String)t).substring("List<".length(), ((String)t).length() - ">".length());
            String listType = this.mapTypeToTS(inner, fieldBO, class_);
            listType = listType.replace(" | ", "[] | ");
            return listType;
        }
        if (((String)t).startsWith("Map<")) {
            String[] inners = ((String)t).substring("Map<".length(), ((String)t).length() - ">".length()).split(",");
            Object maptype = "Map<" + this.mapTypeToTS(inners[0], fieldBO, class_) + ", " + this.mapTypeToTS(inners[1], fieldBO, class_) + ">";
            maptype = ((String)maptype).replace(" | ", "[] | ");
            return maptype;
        }
        if (((String)t).startsWith("JAXBElement<")) {
            String inner = ((String)t).substring("JAXBElement<".length(), ((String)t).length() - 1);
            return this.mapTypeToTS(inner, fieldBO, class_);
        }
        if (((String)t).endsWith("[]")) {
            String inner = ((String)t).substring(0, ((String)t).length() - "[]".length());
            String subTypeArray = this.mapTypeToTS(inner, fieldBO, class_);
            subTypeArray = subTypeArray.replace(" | ", "[] | ");
            return subTypeArray;
        }
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(t)) {
            t = JavaSourceExtractor.mappingForbidenClassNames.get(t);
            return t;
        }
        if (((String)t).contains(".")) {
            String[] javaTypeSplitted = ((String)t).split("\\.");
            Object newType = "";
            for (String jt : javaTypeSplitted) {
                newType = JavaSourceExtractor.mappingForbidenClassNames.containsKey(jt) ? (String)newType + JavaSourceExtractor.mappingForbidenClassNames.get(jt) : (String)newType + jt;
                newType = (String)newType + "_";
            }
            newType = ((String)newType).substring(0, ((String)newType).length() - "_".length());
            return (String)newType + " | null";
        }
        for (String importName : class_.javaFileBO.javaImports) {
            if (!importName.endsWith("." + (String)t)) continue;
            Object keyWord = (importName = importName.replace("." + (String)t, "")).split("\\.")[importName.split("\\.").length - 1].toLowerCase();
            if (((String)keyWord).equals("data")) {
                keyWord = importName.split("\\.")[importName.split("\\.").length - 2].toLowerCase() + "_data";
            }
            t = (String)keyWord + "." + (String)t;
            return (String)t + " | null";
        }
        return (String)t + " | null";
    }

    private String parentTsName(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        String parent = raw;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(parent)) {
            parent = JavaSourceExtractor.mappingForbidenClassNames.get(parent);
        }
        return this.sanitizeCodeIdentifier(parent);
    }

    private void appendTsInterfaceHeader(StringBuilder out, String name, String parent) {
        if (parent != null && !parent.isBlank()) {
            out.append("export interface ").append(name).append(" extends ").append(parent).append(" {\n\n");
        } else {
            out.append("export interface ").append(name).append(" {\n\n");
        }
    }
}

