/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.logger;

import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class AbstractJSONLogger {
    protected static JSONObject format(String msg, Map<String, String> othersInfo) {
        JSONObject logJson = new JSONObject();
        logJson.put("msg", (Object)msg);
        if (othersInfo != null) {
            othersInfo.forEach((k, v) -> logJson.put(k, v));
        }
        return logJson;
    }

    protected static void logJSON(Logger log, Level level, JSONObject obj) {
        switch (level) {
            case DEBUG: {
                log.debug(obj.toString());
                break;
            }
            case ERROR: {
                log.error(obj.toString());
                break;
            }
            case INFO: {
                log.info(obj.toString());
                break;
            }
            case TRACE: {
                log.trace(obj.toString());
                break;
            }
            case WARN: {
                log.warn(obj.toString());
                break;
            }
            default: {
                log.warn("level unknown " + obj.toString());
            }
        }
    }
}

