/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.bootstrap.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResultLoggerExtension
implements TestWatcher,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(TestResultLoggerExtension.class);
    private final List<TestResultStatus> testResultsStatus = new ArrayList<TestResultStatus>();

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        LOG.info("Test Disabled for test {}: with reason :- {}", (Object)context.getDisplayName(), (Object)reason.orElse("No reason"));
        this.testResultsStatus.add(TestResultStatus.DISABLED);
    }

    public void testSuccessful(ExtensionContext context) {
        LOG.info("Test Successful for test {}: ", (Object)context.getDisplayName());
        this.testResultsStatus.add(TestResultStatus.SUCCESSFUL);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        LOG.info("Test Aborted for test {}: ", (Object)context.getDisplayName());
        this.testResultsStatus.add(TestResultStatus.ABORTED);
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        LOG.info("Test Failed for test {}: ", (Object)context.getDisplayName());
        this.testResultsStatus.add(TestResultStatus.FAILED);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Map summary = this.testResultsStatus.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        LOG.info("Test result summary for {} {}", (Object)context.getDisplayName(), summary);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        LOG.info("Test ended for method {}", (Object)context.getDisplayName());
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        LOG.info("Test started for method {}", (Object)context.getDisplayName());
    }

    private static enum TestResultStatus {
        SUCCESSFUL,
        ABORTED,
        FAILED,
        DISABLED;

    }
}

