/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.suite;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.io.AbstractFileLoader;
import fr.emac.gind.commons.utils.io.UploadUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.generic.application.utils.LoadedUsecase;
import fr.emac.gind.gov.ai.chatbot.client.AIChatbotClient;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.SystemGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.system_gov.GJaxbConnectUserToCollaboration;
import fr.emac.gind.gov.system_gov.GJaxbUpdateUser;
import fr.emac.gind.gov.system_gov.GJaxbUpdateUserResponse;
import fr.emac.gind.gov.system_gov.SystemGov;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PublishUserLoader
extends AbstractFileLoader {
    public static Logger LOG = LoggerFactory.getLogger(PublishUserLoader.class);
    private Configuration conf = null;
    private SystemGov systemClient = null;
    private ModelsGov modelsClient = null;
    private CoreGov coreClient = null;
    private AiChatbot aiChatBotClient = null;
    private static final QName NAME = new QName("http://fr.emac.gind/system", "User");
    private GJaxbEffectiveConceptType collaborationMetaModel = null;
    private GJaxbRelation connectedToMetaModel = null;

    public PublishUserLoader() throws Exception {
        GJaxbMetaModel sysMM = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/system/System_MetaModel.xml"), GJaxbMetaModel.class);
        EffectiveMetaModelManager manager = new EffectiveMetaModelManager(new GJaxbEffectiveMetaModel[]{EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel((GJaxbMetaModel)sysMM)});
        this.collaborationMetaModel = manager.getConceptByType(new QName("http://fr.emac.gind/system", "Collaboration"));
        this.connectedToMetaModel = manager.getRelationByType(new QName("http://fr.emac.gind/system", "Connected_To"));
    }

    public void setConfiguration(Object conf) throws Exception {
        this.conf = (Configuration)conf;
        this.systemClient = SystemGovClient.createClient((String)((String)((Configuration)conf).getProperties().get("governance")).replace("/gov", "/GovSystem"));
        this.modelsClient = ModelsGovClient.createClient((String)((String)((Configuration)conf).getProperties().get("governance")).replace("/gov", "/GovModels"));
        this.coreClient = CoreGovClient.createClient((String)((String)((Configuration)conf).getProperties().get("governance")).replace("/gov", "/GovCore"));
        this.aiChatBotClient = AIChatbotClient.createClient((String)((String)((Configuration)conf).getProperties().get("governance")).replace("/gov", "/GovAIChatbot"));
    }

    public QName getQName() {
        return NAME;
    }

    public synchronized void load(File userDirectory) throws Exception {
        if (userDirectory.isFile()) {
            userDirectory = userDirectory.getParentFile();
        }
        LOG.info("load on USER LOADER => " + String.valueOf(userDirectory));
        Optional opFile = FileUtils.listFiles((File)userDirectory, (String[])new String[]{"xml"}, (boolean)true).stream().findFirst();
        for (int retryCpt = 0; !opFile.isPresent() && retryCpt < 10; ++retryCpt) {
            LOG.warn("user file not present !!! Retry...");
            opFile = FileUtils.listFiles((File)userDirectory, (String[])new String[]{"xml"}, (boolean)true).stream().findFirst();
            Thread.sleep(300L);
        }
        if (opFile.isPresent()) {
            File userfile = (File)opFile.get();
            LOG.warn("user file detected: " + String.valueOf(userfile));
            Optional picturefile = FileUtils.listFiles((File)userDirectory, (String[])UploadUtil.AUTHORIZED_IMAGE_EXTENSIONS.toArray(new String[UploadUtil.AUTHORIZED_IMAGE_EXTENSIONS.size()]), (boolean)true).stream().findFirst();
            Document userDoc = DOMUtil.getInstance().parse(userfile);
            GJaxbNode userNode = (GJaxbNode)XMLJAXBContext.getInstance().unmarshallDocument(userDoc, GJaxbNode.class);
            GJaxbUpdateUser req = new GJaxbUpdateUser();
            req.setNode(userNode);
            req.setCreateIfNotExist(true);
            GJaxbUpdateUserResponse resp = this.systemClient.updateUser(req);
            userNode.setId(resp.getId());
            if (ProjectResource.REALWORLD_UC_NODE != null && ProjectResource.WORLD_COLLABORATION_NODE != null) {
                SystemResource.publishPersonCellPhoneWatchToAssociateUserInRealWorld((GJaxbNode)userNode, (CoreGov)this.coreClient, (ModelsGov)this.modelsClient, (SystemGov)this.systemClient, (AiChatbot)this.aiChatBotClient);
            }
            File rootDirectory = new File(RIOConstant.RESOURCES_FOLDER);
            rootDirectory = new File(rootDirectory, "users");
            rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName((String)userNode.getId()));
            rootDirectory = new File(rootDirectory, "pictures");
            if (picturefile.isPresent()) {
                FileUtils.copyFileToDirectory((File)((File)picturefile.get()), (File)rootDirectory, (boolean)true);
            }
            if (!ProjectResource.USECASES_ALREADY_LOADED.isEmpty()) {
                LoadedUsecase uc = (LoadedUsecase)ProjectResource.USECASES_ALREADY_LOADED.values().iterator().next();
                GJaxbNode colladNode = uc.getCollaboration();
                GJaxbNode kownledgeNode = uc.getKnowledgeSpace();
                GenericModelHelper.findProperty((String)"Presence", (List)userNode.getProperty(), (boolean)true).setValue("Available");
                GenericModelHelper.findProperty((String)"currentCollaborationName", (List)userNode.getProperty(), (boolean)true).setValue(GenericModelHelper.getName((GJaxbNode)colladNode));
                GenericModelHelper.findProperty((String)"currentKnowledgeSpaceName", (List)userNode.getProperty(), (boolean)true).setValue(GenericModelHelper.getName((GJaxbNode)kownledgeNode));
                GJaxbUpdateUser upReq = new GJaxbUpdateUser();
                upReq.setNode(userNode);
                upReq.setCreateIfNotExist(true);
                this.systemClient.updateUser(upReq);
                GJaxbConnectUserToCollaboration reqConnColl = new GJaxbConnectUserToCollaboration();
                reqConnColl.setCollaborationId(colladNode.getId());
                reqConnColl.setUserId(userNode.getId());
                this.systemClient.connectUserToCollaboration(reqConnColl);
            }
            LOG.info("User added: " + GenericModelHelper.getName((GJaxbNode)userNode));
        } else {
            LOG.warn("File in user directory not found: " + String.valueOf(userDirectory));
        }
    }

    public List<File> listenedDirectories() {
        return List.of(new File("./target/listener"));
    }
}

