/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.usecase.GJaxbCompleteUsecaseDefinition;
import fr.emac.gind.usecase.GJaxbLocationType;
import fr.emac.gind.usecase.GJaxbModelURLType;
import fr.emac.gind.usecase.GJaxbResourceType;
import fr.emac.gind.usecase.GJaxbResourceURLType;
import fr.emac.gind.usecase.GJaxbShortUsecaseDefinitionType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RIOAbstractProject {
    private static final Logger LOG = LoggerFactory.getLogger((String)RIOAbstractProject.class.getName());
    protected String rootDirectory = null;
    protected GJaxbShortUsecaseDefinitionType usecaseDef = new GJaxbShortUsecaseDefinitionType();
    protected GJaxbModelURLType project = null;
    private final Map<GJaxbResourceType, List<GJaxbResourceURLType>> map = new HashMap<GJaxbResourceType, List<GJaxbResourceURLType>>();
    private final Map<String, JSONObject> context = new HashMap<String, JSONObject>();
    protected List<GJaxbResourceURLType> results = new ArrayList<GJaxbResourceURLType>();

    public RIOAbstractProject(String rootDir) throws Exception {
        try {
            this.rootDirectory = rootDir;
            this.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public abstract void beforeInit() throws Exception;

    public abstract void afterInit() throws Exception;

    private void init() throws Exception {
        this.beforeInit();
        assert (this.rootDirectory != null);
        this.usecaseDef.setLocation(GJaxbLocationType.EMBEDDED);
        this.map.put(GJaxbResourceType.MODEL, new ArrayList());
        this.map.put(GJaxbResourceType.DOMAIN, new ArrayList());
        this.map.put(GJaxbResourceType.PACKAGE, new ArrayList());
        this.map.put(GJaxbResourceType.META_MODEL, new ArrayList());
        this.map.put(GJaxbResourceType.CEP_RULE, new ArrayList());
        this.map.put(GJaxbResourceType.ML_RULE, new ArrayList());
        this.map.put(GJaxbResourceType.EXPERIMENTAL_PLAN, new ArrayList());
        this.map.put(GJaxbResourceType.INPUT_DETECTION_DATA, new ArrayList());
        this.map.put(GJaxbResourceType.GAME_SCENARIO, new ArrayList());
        this.map.put(GJaxbResourceType.DATASET, new ArrayList());
        this.map.put(GJaxbResourceType.DISTANCE_TIME_MATRIX, new ArrayList());
        this.map.put(GJaxbResourceType.BACKUP_DATABASE, new ArrayList());
        this.map.put(GJaxbResourceType.USER, new ArrayList());
        this.map.put(GJaxbResourceType.RAG, new ArrayList());
        URL root = Thread.currentThread().getContextClassLoader().getResource(this.rootDirectory);
        if (root == null) {
            root = new File(this.rootDirectory).toURI().toURL();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        Path myPath = null;
        if (root.toURI().getScheme().equals("jar")) {
            FileSystem fileSystem = null;
            try {
                fileSystem = FileSystems.getFileSystem(root.toURI());
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(root.toURI(), Collections.emptyMap());
            }
            myPath = fileSystem.getPath(this.rootDirectory, new String[0]);
        } else {
            myPath = Paths.get(root.toURI());
        }
        Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);
        Iterator<Object> it = walk.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            LOG.debug("file: " + String.valueOf(p));
            urls.add(p.toUri().toURL());
        }
        walk.close();
        for (URL url : urls) {
            if (url.getFile().indexOf(".", url.getFile().lastIndexOf("/")) <= 0) continue;
            String fileName = url.getFile().substring(url.getFile().lastIndexOf("/") + 1, url.getFile().lastIndexOf(".")).replace("%20", " ");
            LOG.debug("uc url = " + String.valueOf(url));
            GJaxbResourceURLType rsc = null;
            if (url.getFile().contains("models")) {
                if ("project".equals(fileName)) {
                    rsc = RIOAbstractProject.createModelUrlType(fileName, GJaxbResourceType.MODEL, url.toString(), true, true, GJaxbStatusType.ACTIVE);
                    this.project = rsc;
                    this.map.get((Object)GJaxbResourceType.MODEL).add(rsc);
                    continue;
                }
                if (fileName.startsWith("freezed_")) {
                    rsc = RIOAbstractProject.createModelUrlType(fileName, GJaxbResourceType.MODEL, url.toString(), true, false, GJaxbStatusType.FREEZE);
                    this.map.get((Object)GJaxbResourceType.MODEL).add(rsc);
                    continue;
                }
                rsc = RIOAbstractProject.createModelUrlType(fileName, GJaxbResourceType.MODEL, url.toString(), true, false, GJaxbStatusType.ACTIVE);
                this.map.get((Object)GJaxbResourceType.MODEL).add(rsc);
                continue;
            }
            if (url.getPath().contains("metamodel")) {
                if (url.getPath().endsWith("domain.xml")) {
                    rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.DOMAIN, url.toURI().toURL().toString());
                    this.map.get((Object)GJaxbResourceType.DOMAIN).add(rsc);
                    continue;
                }
                if (url.getPath().endsWith("_Package.xml")) {
                    rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.PACKAGE, url.toURI().toURL().toString());
                    this.map.get((Object)GJaxbResourceType.PACKAGE).add(rsc);
                    continue;
                }
                if (!url.getPath().endsWith("_MetaModel.xml")) continue;
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.META_MODEL, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.META_MODEL).add(rsc);
                continue;
            }
            if (url.getPath().contains("cep_rules")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.CEP_RULE, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.CEP_RULE).add(rsc);
                continue;
            }
            if (url.getPath().contains("ml_rules") && url.getPath().contains("mlConfig")) {
                fileName = url.getPath().substring(url.getPath().indexOf("ml_rules/") + "ml_rules/".length(), url.getPath().lastIndexOf("/resources/"));
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.ML_RULE, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.ML_RULE).add(rsc);
                continue;
            }
            if (url.getPath().contains("distance_time_cache_matrix")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.DISTANCE_TIME_MATRIX, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.DISTANCE_TIME_MATRIX).add(rsc);
                continue;
            }
            if (url.getPath().contains("datasets")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.DATASET, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.DATASET).add(rsc);
                continue;
            }
            if (url.getPath().contains("game_scenarios")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.GAME_SCENARIO, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.GAME_SCENARIO).add(rsc);
                continue;
            }
            if (url.getPath().contains("database")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.BACKUP_DATABASE, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.BACKUP_DATABASE).add(rsc);
                rsc.setSelected(false);
                continue;
            }
            if (url.getPath().contains("rag")) {
                rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.RAG, url.toURI().toURL().toString());
                this.map.get((Object)GJaxbResourceType.RAG).add(rsc);
                rsc.setSelected(false);
                continue;
            }
            if (!url.getPath().contains("users") || !url.toURI().toURL().toString().endsWith(".xml")) continue;
            rsc = RIOAbstractProject.createResourceUrlType(fileName, GJaxbResourceType.USER, url.toURI().toURL().toString());
            this.map.get((Object)GJaxbResourceType.USER).add(rsc);
            rsc.setSelected(false);
        }
        if (this.project != null) {
            GJaxbProperty domainsProp;
            GJaxbGenericModel projModel = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(this.project.getUrl()).toURL(), GJaxbGenericModel.class);
            this.usecaseDef.setId(((GJaxbNode)projModel.getNode().get(0)).getId());
            assert (!projModel.getNode().isEmpty()) : "Impossible to find project at: " + this.project.getUrl();
            GJaxbProperty propName = GenericModelHelper.findProperty((String)"name", (List)((GJaxbNode)projModel.getNode().get(0)).getProperty());
            assert (propName != null);
            if (GenericModelHelper.findProperty((String)"picture", (List)((GJaxbNode)projModel.getNode().get(0)).getProperty()) != null) {
                this.usecaseDef.setImageUrl(GenericModelHelper.findProperty((String)"picture", (List)((GJaxbNode)projModel.getNode().get(0)).getProperty()).getValue());
            }
            if (!projModel.getName().trim().equals(propName.getValue().trim())) {
                throw new Exception("Project name in '" + this.project.getUrl() + "' must be the same : " + projModel.getName() + " != " + propName.getValue());
            }
            this.usecaseDef.setName(projModel.getName());
            String projectDirName = null;
            if (this.rootDirectory.endsWith("/")) {
                this.rootDirectory = this.rootDirectory.substring(0, this.rootDirectory.lastIndexOf("/"));
            } else if (this.rootDirectory.endsWith("\\")) {
                this.rootDirectory = this.rootDirectory.substring(0, this.rootDirectory.lastIndexOf("\\"));
            }
            if (this.rootDirectory.lastIndexOf("/") > 0) {
                projectDirName = this.rootDirectory.substring(this.rootDirectory.lastIndexOf("/") + "/".length());
            } else if (this.rootDirectory.lastIndexOf("\\") > 0) {
                projectDirName = this.rootDirectory.substring(this.rootDirectory.lastIndexOf("\\") + "\\".length());
            }
            this.usecaseDef.setFriendlyName(RegExpHelper.toRegexFriendlyName((String)this.usecaseDef.getName()).toLowerCase());
            projectDirName = RegExpHelper.toRegexFriendlyName((String)projectDirName.toLowerCase());
            if (projectDirName.endsWith("_")) {
                projectDirName = projectDirName.substring(0, projectDirName.length() - 1);
            }
            if (!projectDirName.equals(this.usecaseDef.getFriendlyName())) {
                throw new Exception("Project directory name must be the same that the frienldy name (knownledge space name): " + this.usecaseDef.getFriendlyName() + " != " + projectDirName);
            }
            GJaxbProperty descriptionProp = GenericModelHelper.findProperty((String)"description", (List)((GJaxbNode)projModel.getNode().get(0)).getProperty());
            if (descriptionProp != null && descriptionProp.getValue() != null) {
                this.usecaseDef.setDescription(descriptionProp.getValue());
            }
            if ((domainsProp = GenericModelHelper.findProperty((String)"domains", (List)((GJaxbNode)projModel.getNode().get(0)).getProperty())) != null && domainsProp.getValue() != null) {
                this.usecaseDef.setDomains(domainsProp.getValue());
            }
        }
        this.afterInit();
    }

    public GJaxbShortUsecaseDefinitionType getUsecaseDef() {
        return this.usecaseDef;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public Map<GJaxbResourceType, List<GJaxbResourceURLType>> getMap() {
        return this.map;
    }

    public Map<String, JSONObject> getContext() {
        return this.context;
    }

    public List<GJaxbResourceURLType> getResults() {
        return this.results;
    }

    public GJaxbResourceURLType findResourceByName(String name, GJaxbResourceType type) {
        List<GJaxbResourceURLType> resources = this.map.get((Object)type);
        for (GJaxbResourceURLType rsc : resources) {
            if (!rsc.getName().equalsIgnoreCase(name)) continue;
            return rsc;
        }
        return null;
    }

    public GJaxbResourceURLType findResourceByUrl(String url, GJaxbResourceType type) {
        List<GJaxbResourceURLType> resources = this.map.get((Object)type);
        for (GJaxbResourceURLType rsc : resources) {
            if (!rsc.getUrl().equalsIgnoreCase(url)) continue;
            return rsc;
        }
        return null;
    }

    public GJaxbModelURLType getProject() {
        return this.project;
    }

    public GJaxbCompleteUsecaseDefinition createCompleteUsecaseDefinition() throws Exception {
        GJaxbCompleteUsecaseDefinition completeUc = new GJaxbCompleteUsecaseDefinition();
        completeUc.setId(this.usecaseDef.getId());
        completeUc.setName(this.usecaseDef.getName());
        completeUc.setFriendlyName(this.usecaseDef.getFriendlyName());
        completeUc.setSize(this.usecaseDef.getSize());
        completeUc.setLocation(this.usecaseDef.getLocation());
        completeUc.setDescription(this.usecaseDef.getDescription());
        completeUc.setImageUrl(this.usecaseDef.getImageUrl());
        completeUc.setZipResourcesURL(this.usecaseDef.getZipResourcesURL());
        completeUc.setDomains(this.usecaseDef.getDomains());
        completeUc.setIsDefaultReferenceUsecase(this.usecaseDef.isIsDefaultReferenceUsecase());
        completeUc.setIsDefaultSharedResourcesUsecase(this.usecaseDef.isIsDefaultSharedResourcesUsecase());
        completeUc.setRootDir(this.rootDirectory);
        completeUc.setProject(this.project);
        for (Map.Entry<GJaxbResourceType, List<GJaxbResourceURLType>> entry : this.map.entrySet()) {
            GJaxbCompleteUsecaseDefinition.ResourcesByType rscsByType = new GJaxbCompleteUsecaseDefinition.ResourcesByType();
            rscsByType.setType(entry.getKey());
            for (GJaxbResourceURLType rsc : entry.getValue()) {
                rscsByType.getResources().add(rsc);
            }
            if (rscsByType.getResources().size() <= 0) continue;
            completeUc.getResourcesByType().add(rscsByType);
        }
        return completeUc;
    }

    public static GJaxbResourceURLType createResourceUrlType(String name, GJaxbResourceType type, String url) {
        GJaxbResourceURLType rsc = new GJaxbResourceURLType();
        rsc.setName(name);
        rsc.setResourceType(type);
        rsc.setUrl(url);
        rsc.setSelected(true);
        rsc.setDisabled(false);
        return rsc;
    }

    public static GJaxbModelURLType createModelUrlType(String name, GJaxbResourceType type, String url, boolean selected, boolean disabled, GJaxbStatusType status) {
        GJaxbModelURLType rsc = new GJaxbModelURLType();
        rsc.setName(name);
        rsc.setResourceType(type);
        rsc.setUrl(url);
        rsc.setSelected(selected);
        rsc.setDisabled(disabled);
        rsc.setStatus(status);
        return rsc;
    }
}

