/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.usecase.GJaxbCompleteUsecaseDefinition;
import fr.emac.gind.usecase.GJaxbLocationType;
import fr.emac.gind.usecase.GJaxbResourceURLType;
import fr.emac.gind.usecase.GJaxbShortUsecaseDefinitionType;
import fr.emac.gind.usecases.RIOAbstractProject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RIOUsecasesManager {
    public static boolean DESACTIVATE_EMBEDDED_USECASE = false;
    private static final String REMOTE_USECASES_DIRECTORY = "https://code-gi.mines-albi.fr/nexus/content/sites/distribution/fr.emac.gind/gind-r-iosuite-uc/";
    private ConnexionType connexion = ConnexionType.ON_LINE;
    private final ServiceLoader<RIOAbstractProject> ucLoader = ServiceLoader.load(RIOAbstractProject.class);
    private final List<RIOAbstractProject> embeddedUsecases = new ArrayList<RIOAbstractProject>();
    private final List<GJaxbShortUsecaseDefinitionType> notDownloadedUsecases = new ArrayList<GJaxbShortUsecaseDefinitionType>();
    private final List<RIOAbstractProject> downloadedUsecases = new ArrayList<RIOAbstractProject>();
    private String version = null;
    private static RIOUsecasesManager INSTANCE = null;

    private RIOUsecasesManager(String version) throws Exception {
        this.version = version;
        if (Configuration.MODE == Configuration.ModeType.DEV && this.version.equals("${project.version}")) {
            this.version = "1.0-SNAPSHOT";
        }
        this.initUsecases();
    }

    public static RIOUsecasesManager getInstance(String version) throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new RIOUsecasesManager(version);
        }
        return INSTANCE;
    }

    public void initUsecases() throws Exception {
        this.embeddedUsecases.addAll(this.discoverEmbeddedUsecases());
        this.downloadedUsecases.addAll(this.discoverDownloadedUsecase());
        this.notDownloadedUsecases.addAll(this.discoverNotDownloadedUsecases());
    }

    private List<RIOAbstractProject> discoverEmbeddedUsecases() throws Exception {
        ArrayList<RIOAbstractProject> res = new ArrayList<RIOAbstractProject>();
        this.ucLoader.reload();
        for (RIOAbstractProject uc : this.ucLoader) {
            uc.getUsecaseDef().setLocation(GJaxbLocationType.EMBEDDED);
            res.add(uc);
        }
        return res;
    }

    public List<RIOAbstractProject> discoverDownloadedUsecase() throws Exception {
        ArrayList<RIOAbstractProject> localUcs = new ArrayList<RIOAbstractProject>();
        String userHomeDirectoryName = System.getProperty("user.home");
        File userHomeDirectory = new File(userHomeDirectoryName);
        if (userHomeDirectory.isDirectory()) {
            File[] downloadedUsecasesDirectories;
            File localZipRepository = new File(userHomeDirectory, "/gindRepository/usecases/");
            localZipRepository.mkdirs();
            for (File ucF : downloadedUsecasesDirectories = localZipRepository.listFiles(new FileFilter(this){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                String parentDirName = ucF.getPath().substring(ucF.getPath().lastIndexOf(File.separator) + File.separator.length());
                String ucName = parentDirName.replace("gind-usecases-", "").replace("gind-prototype-riosuite-uc-", "").replace("-uc-resources", "").replace(this.version, "");
                ucName = RegExpHelper.toRegexFriendlyName((String)ucName.substring(0, ucName.lastIndexOf("-"))).toLowerCase().replace("-", "_");
                String ucRootDir = String.valueOf(localZipRepository) + File.separator + parentDirName + "/gind/usecases/" + ucName.toLowerCase();
                RIOAbstractProject project = new RIOAbstractProject(this, ucRootDir){

                    @Override
                    public void beforeInit() throws Exception {
                    }

                    @Override
                    public void afterInit() throws Exception {
                    }
                };
                project.getUsecaseDef().setLocation(GJaxbLocationType.DOWNLOADED);
                this.downloadedUsecases.add(project);
            }
        }
        return localUcs;
    }

    private List<GJaxbShortUsecaseDefinitionType> discoverNotDownloadedUsecases() throws Exception {
        ArrayList<GJaxbShortUsecaseDefinitionType> ucDefs = new ArrayList<GJaxbShortUsecaseDefinitionType>();
        URL nexusUcDepot = URI.create(REMOTE_USECASES_DIRECTORY).toURL();
        String buffer = null;
        try {
            buffer = FileUtil.getContents((InputStream)nexusUcDepot.openStream()).replace("&nbsp;", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connexion = ConnexionType.OFF_LINE;
        }
        if (ConnexionType.ON_LINE.equals((Object)this.connexion)) {
            String htmlTable = buffer.substring(buffer.indexOf("<table"), buffer.indexOf("</table>") + "</table>".length());
            Document table = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(htmlTable.getBytes()));
            NodeList trLines = table.getElementsByTagName("tr");
            for (int i = 0; i < trLines.getLength(); ++i) {
                Element tr = (Element)trLines.item(i);
                GJaxbShortUsecaseDefinitionType ucDef = this.analyzeTRLine(tr);
                if (ucDef == null) continue;
                ucDefs.add(ucDef);
            }
        }
        return ucDefs;
    }

    private GJaxbShortUsecaseDefinitionType analyzeTRLine(Element tr) throws Exception {
        GJaxbShortUsecaseDefinitionType ucDef = null;
        Object project = null;
        NodeList tdRows = tr.getElementsByTagName("td");
        for (int i = 0; i < tdRows.getLength(); ++i) {
            Element a;
            String ucPackageName;
            Element td = (Element)tdRows.item(i);
            NodeList as = td.getElementsByTagName("a");
            if (as.getLength() <= 0 || (ucPackageName = (a = (Element)as.item(0)).getTextContent()).equals("Parent Directory")) continue;
            String ahref = a.getAttribute("href");
            try {
                ucDef = this.createUCDefintionFormRemoteURL(ahref);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ucDef;
    }

    private GJaxbShortUsecaseDefinitionType createUCDefintionFormRemoteURL(String remoteUcUrl) throws Exception {
        GJaxbShortUsecaseDefinitionType ucDef = null;
        if (remoteUcUrl.contains(this.version)) {
            ucDef = new GJaxbShortUsecaseDefinitionType();
            URL ucDepot = URI.create(remoteUcUrl).toURL();
            String ucNamePackage = remoteUcUrl.split("/")[remoteUcUrl.split("/").length - 1];
            String ucName = ucNamePackage.replace("gind-usecases-", "").replace("gind-prototype-riosuite-uc-", "");
            ucName = RegExpHelper.toRegexFriendlyName((String)ucName.substring(0, ucName.indexOf("-" + this.version + "-rsc"))).replace("-", "_").toLowerCase();
            String projectUrl = remoteUcUrl + "gind/usecases/" + ucName + "/models/project.xml";
            GJaxbNode project = (GJaxbNode)((GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(projectUrl).toURL(), GJaxbGenericModel.class)).getNode().get(0);
            ucDef.setName(GenericModelHelper.findProperty((String)"name", (List)project.getProperty()).getValue());
            ucDef.setFriendlyName(RegExpHelper.toRegexFriendlyName((String)ucDef.getName()).toLowerCase());
            ucDef.setDescription(GenericModelHelper.findProperty((String)"description", (List)project.getProperty()).getValue());
            ucDef.setDomains(GenericModelHelper.findProperty((String)"domains", (List)project.getProperty()).getValue());
            ucDef.setLocation(GJaxbLocationType.NOT_DOWNLOADED);
            String picture = GenericModelHelper.findProperty((String)"picture", (List)project.getProperty()).getValue();
            String pictureName = picture.substring(picture.lastIndexOf("/") + "/".length());
            String projectId = project.getId();
            String imageUrl = remoteUcUrl + "gind/usecases/" + ucName + "/resources/project/" + projectId + "/" + pictureName;
            ucDef.setImageUrl(imageUrl);
            String buffer = FileUtil.getContents((InputStream)ucDepot.openStream()).replace("&nbsp;", "");
            String htmlTable = buffer.substring(buffer.indexOf("<table"), buffer.indexOf("</table>") + "</table>".length());
            Document table = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(htmlTable.getBytes()));
            NodeList trLines = table.getElementsByTagName("tr");
            for (int i = 0; i < trLines.getLength(); ++i) {
                Element tr = (Element)trLines.item(i);
                NodeList tdRows = tr.getElementsByTagName("td");
                for (int j = 0; j < tdRows.getLength(); ++j) {
                    Element td = (Element)tdRows.item(j);
                    NodeList as = td.getElementsByTagName("a");
                    if (as.getLength() > 0) {
                        String ahref;
                        Element a = (Element)as.item(0);
                        String ucPackageName = a.getTextContent();
                        if (ucPackageName.equals("Parent Directory") || !(ahref = a.getAttribute("href")).endsWith(".zip")) continue;
                        ucDef.setZipResourcesURL(ahref);
                        continue;
                    }
                    if (ucDef.getZipResourcesURL() == null) continue;
                    String possibleSize = td.getTextContent().trim();
                    try {
                        ucDef.setSize(Integer.parseInt(possibleSize));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return ucDef;
    }

    public List<RIOAbstractProject> getEmbeddedUsecases() {
        return this.embeddedUsecases;
    }

    public List<GJaxbShortUsecaseDefinitionType> getDownloadUsecases() {
        return this.notDownloadedUsecases;
    }

    public RIOAbstractProject download(GJaxbShortUsecaseDefinitionType ucDef) throws Exception {
        RIOAbstractProject project = null;
        String userHomeDirectoryName = System.getProperty("user.home");
        File userHomeDirectory = new File(userHomeDirectoryName);
        if (userHomeDirectory.isDirectory()) {
            File localZipRepository = new File(userHomeDirectory, "/gindRepository/usecases/");
            URL ucUrl = URI.create(ucDef.getZipResourcesURL()).toURL();
            InputStream zip = ucUrl.openStream();
            String parentDirName = ucUrl.getPath().substring(ucUrl.getPath().lastIndexOf("/")).replace(".zip", "");
            ZipUtil.unZip((InputStream)zip, (File)localZipRepository);
            String ucRootDir = (String.valueOf(localZipRepository) + parentDirName + "/gind/usecases/" + ucDef.getFriendlyName()).replace("\\", "/");
            project = new RIOAbstractProject(this, ucRootDir){

                @Override
                public void beforeInit() throws Exception {
                }

                @Override
                public void afterInit() throws Exception {
                }
            };
            project.getUsecaseDef().setLocation(GJaxbLocationType.DOWNLOADED);
            this.downloadedUsecases.add(project);
            this.notDownloadedUsecases.removeIf(p -> p.getName().equals(ucDef.getName()));
        }
        return project;
    }

    public RIOAbstractProject findAvailableUsecaseByFriendlyName(String name, boolean downloadIfNeeded, GJaxbCompleteUsecaseDefinition usecase) throws Exception {
        if (!DESACTIVATE_EMBEDDED_USECASE) {
            for (RIOAbstractProject project : this.embeddedUsecases) {
                if (!project.getUsecaseDef().getFriendlyName().equalsIgnoreCase(name)) continue;
                return project;
            }
        }
        for (RIOAbstractProject project : this.downloadedUsecases) {
            if (!project.getUsecaseDef().getFriendlyName().equalsIgnoreCase(name)) continue;
            return project;
        }
        if (downloadIfNeeded) {
            for (GJaxbShortUsecaseDefinitionType shortDef : this.notDownloadedUsecases) {
                if (!shortDef.getFriendlyName().equalsIgnoreCase(name)) continue;
                RIOAbstractProject project = this.download(shortDef);
                if (usecase != null) {
                    GJaxbCompleteUsecaseDefinition completeUsecaseDef = project.createCompleteUsecaseDefinition();
                    usecase.getResourcesByType().clear();
                    for (GJaxbCompleteUsecaseDefinition.ResourcesByType rscsByType : completeUsecaseDef.getResourcesByType()) {
                        GJaxbCompleteUsecaseDefinition.ResourcesByType rscsByTypeCloned = new GJaxbCompleteUsecaseDefinition.ResourcesByType();
                        rscsByTypeCloned.setType(rscsByType.getType());
                        usecase.getResourcesByType().add(rscsByTypeCloned);
                        for (GJaxbResourceURLType rscBrowser : rscsByType.getResources()) {
                            GJaxbResourceURLType rscBrowserCloned = new GJaxbResourceURLType();
                            rscBrowserCloned.setName(rscBrowser.getName());
                            rscBrowserCloned.setUrl(rscBrowser.getUrl());
                            rscBrowserCloned.setResourceType(rscBrowser.getResourceType());
                            rscBrowserCloned.setDisabled(rscBrowser.isDisabled());
                            rscBrowserCloned.setSelected(true);
                            rscsByTypeCloned.getResources().add(rscBrowserCloned);
                        }
                    }
                }
                return project;
            }
        }
        return null;
    }

    public List<GJaxbShortUsecaseDefinitionType> getFoundUsecases() throws Exception {
        HashMap<String, GJaxbShortUsecaseDefinitionType> maps = new HashMap<String, GJaxbShortUsecaseDefinitionType>();
        if (!DESACTIVATE_EMBEDDED_USECASE) {
            for (RIOAbstractProject rIOAbstractProject : this.embeddedUsecases) {
                if (maps.get(rIOAbstractProject.getUsecaseDef().getName()) != null) continue;
                maps.put(rIOAbstractProject.getUsecaseDef().getName(), rIOAbstractProject.createCompleteUsecaseDefinition());
            }
        }
        for (RIOAbstractProject rIOAbstractProject : this.downloadedUsecases) {
            if (maps.get(rIOAbstractProject.getUsecaseDef().getName()) != null) continue;
            maps.put(rIOAbstractProject.getUsecaseDef().getName(), rIOAbstractProject.createCompleteUsecaseDefinition());
        }
        for (GJaxbShortUsecaseDefinitionType gJaxbShortUsecaseDefinitionType : this.notDownloadedUsecases) {
            if (maps.get(gJaxbShortUsecaseDefinitionType.getName()) != null) continue;
            maps.put(gJaxbShortUsecaseDefinitionType.getName(), gJaxbShortUsecaseDefinitionType);
        }
        ArrayList<GJaxbShortUsecaseDefinitionType> res = new ArrayList<GJaxbShortUsecaseDefinitionType>();
        for (GJaxbShortUsecaseDefinitionType obj : maps.values()) {
            res.add(obj);
        }
        return res;
    }

    public static enum ConnexionType {
        ON_LINE,
        OFF_LINE;

    }
}

