/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.humantask.GJaxbAddHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.HumanTaskResource;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="/wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class HumanTaskTestNotifierClient
extends AbstractNotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)HumanTaskTestNotifierClient.class.getName());
    private Map<String, Map.Entry<String, String>> humanAnswers = null;
    private DWUser user = null;
    private RIOSuiteAbstractBundle bundle = null;

    public HumanTaskTestNotifierClient(String address, Map<String, Map.Entry<String, String>> humanAnswers, DWUser user, RIOSuiteAbstractBundle bundle) throws Exception {
        super(address);
        this.humanAnswers = humanAnswers;
        this.user = user;
        this.bundle = bundle;
    }

    public void notify(GJaxbNotify notify) {
        try {
            GJaxbTask ht = null;
            Document msg = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            LOG.debug("ADD HUMAN TASK EVENT ? " + msg.getDocumentElement().getLocalName());
            if (msg.getDocumentElement().getLocalName().equals("addHumanTaskEvent") && msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/humantask")) {
                GJaxbAddHumanTaskEvent me = (GJaxbAddHumanTaskEvent)XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbAddHumanTaskEvent.class);
                ht = me.getTask();
                Map.Entry<String, String> answers = this.humanAnswers.get(GenericModelHelper.getName((GJaxbNode)ht.getNode()));
                LOG.debug("Task name to seek in map " + GenericModelHelper.getName((GJaxbNode)ht.getNode()));
                String acceptResponse = answers.getKey();
                String achievedResponse = answers.getValue();
                this.performHumanTask(ht, this.user, acceptResponse, achievedResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail();
        }
    }

    protected void performHumanTask(GJaxbTask t, DWUser user, String acceptResponse, String achievedResponse) {
        try {
            LOG.debug("RECEIVING TASK " + GenericModelHelper.getName((GJaxbNode)t.getNode()));
            LOG.debug(JSONJAXBContext.getInstance().marshallAnyElement((Object)t.getNode()));
            GJaxbUpdateTask updateRequest = new GJaxbUpdateTask();
            GJaxbProperty acceptance = GenericModelHelper.findProperty((String)"Acceptance", (List)t.getNode().getProperty(), (boolean)true);
            GJaxbProperty achieved = GenericModelHelper.findProperty((String)"Achieved", (List)t.getNode().getProperty(), (boolean)true);
            acceptance.setValue(acceptResponse);
            achieved.setValue(achievedResponse);
            updateRequest.setTask(t);
            updateRequest.setCollaborationName(user.getCurrentCollaborationName());
            updateRequest.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            updateRequest.setDeployedTaskId(t.getDeployedTaskId());
            LOG.debug("UPDATING TASK " + GenericModelHelper.getName((GJaxbNode)t.getNode()));
            ((HumanTaskResource)this.bundle.getRioga().getResourcesManager().findResource(HumanTaskResource.class)).updateTask(user, updateRequest);
        }
        catch (Exception e) {
            LOG.debug("PROBLEM UPDATING TASK");
            e.printStackTrace();
        }
    }
}

