/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application;

import com.codahale.metrics.health.HealthCheck;
import fr.emac.gind.application.model.GJaxbApplication;
import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.commons.utils.yaml.YMLConfigGenerator;
import fr.emac.gind.database.mongodb.embedded.EmbeddedMongoDb;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.ApplicationContext;
import fr.emac.gind.generic.application.DummyHealthCheck;
import fr.emac.gind.generic.application.RIOExceptionMapper;
import fr.emac.gind.generic.application.RIOHumanTaskNotifierClient;
import fr.emac.gind.generic.application.auth.BasicAuthenticator;
import fr.emac.gind.generic.application.auth.BasicCredentialAuthFilter;
import fr.emac.gind.generic.application.auth.UserRoleAuthorizer;
import fr.emac.gind.generic.application.bundles.AssetsInterceptorBundle;
import fr.emac.gind.generic.application.bundles.modifier.ApplicationNameModifierResource;
import fr.emac.gind.generic.application.bundles.modifier.ExternalModifierResource;
import fr.emac.gind.generic.application.configuration.GenericConfiguration;
import fr.emac.gind.generic.application.soap.WebsocketCommandImpl;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.generic.application.websocket.chat.ChatServerServlet;
import fr.emac.gind.generic.application.websocket.pubsub.PubSubServerServlet;
import fr.emac.gind.generic.application.websocket.sockjs.SockJSServerServlet;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaContainerConfig;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaManager;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.metamodel.GJaxbEdgeMetaModeling;
import fr.emac.gind.modeler.metamodel.GJaxbModelingEdgeViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.models.generic.modeler.utils.svg.SVGGenerator;
import fr.emac.gind.rio.dw.resources.DWApplicationContextResource;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.rio.dw.resources.HumanTaskResource;
import fr.emac.gind.rio.dw.resources.OnlyGetResource;
import fr.emac.gind.rio.dw.resources.StorageResource;
import fr.emac.gind.rio.dw.resources.gov.AIChatbotResource;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.MetaModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.Neo4JResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.websocket.command.WebsocketCommand;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletRegistration;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.xml.ws.Endpoint;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DWApplicationService
extends Application<GenericConfiguration> {
    private static Logger LOG = LoggerFactory.getLogger((String)DWApplicationService.class.getName());
    protected GJaxbApplication application = null;
    protected ApplicationContext applicationContext = null;
    protected Configuration conf = null;
    protected URL ymlConfig = null;
    protected Map<String, Object> context = new HashMap<String, Object>();
    private List<Class<?>> webSocketResources = new ArrayList();
    private ServletRegistration.Dynamic pubSubWebsocket = null;
    private static EmbeddedMongoDb embeddedMongoDB = null;
    private static boolean SHARED_RESOURCES_LOADED = false;
    private Environment environment = null;
    private RestResourceManager resourcesManager = null;
    protected AssetsInterceptorBundle interceptorBundle = null;
    protected static WebsocketCommand WEB_SOCKET_COMMAND = null;
    protected static Endpoint WEB_SOCKET_COMMAND_SERVER = null;
    protected OnlyGetResource hardCodedResource = null;
    protected SystemResource systemResource = null;
    protected HumanTaskResource humanTaskResource = null;
    protected CoreResource coreResource = null;
    protected MetaModelsResource metaModelsResource = null;
    protected ModelsResource modelsResource = null;
    protected AIChatbotResource aiChatbotResource = null;
    protected FileResource fileResource = null;
    protected DWApplicationContextResource contextResource = null;
    private String queryPath = null;
    private String applicationUrl = null;
    protected static NotificationConsumerWebService HUMAN_TASK_CONSUMER = null;

    public DWApplicationService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public DWApplicationService(Map<String, Object> context) throws Exception {
        this.context = context;
    }

    public WebsocketCommand getWebsocketCommand() {
        return WEB_SOCKET_COMMAND;
    }

    protected void bootstrapLogging() {
    }

    public String getName() {
        return "generic-application";
    }

    public String getShortPath() {
        return "/webjars/" + this.getName() + "/generated/index.html";
    }

    public String getRedirection() {
        return "";
    }

    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public void boot(Configuration conf) throws Exception {
        try {
            this.conf = conf;
            this.ymlConfig = YMLConfigGenerator.generate((Configuration)conf, (String)this.getName());
            LOG.info("ymlConfig: " + String.valueOf(this.ymlConfig));
            LOG.debug("ymlConfig exist: " + new File(this.ymlConfig.toURI()).exists());
            if (this.conf.getProperties().get("mongodb-database-embedded") != null && Boolean.valueOf(((String)this.conf.getProperties().get("mongodb-database-embedded")).toString()).booleanValue()) {
                LOG.info("Start embedded mongoDB");
                DWApplicationService.startEmbeddedMongDB(false, conf);
            }
            if (this.conf.getProperties().get("ollama") != null && !((String)this.conf.getProperties().get("ollama")).isBlank()) {
                List containerConfigs = OllamaContainerConfig.parse((JSONArray)new JSONArray((String)this.conf.getProperties().get("ollama")));
                OllamaManager.getInstance().addContainers(containerConfigs);
                OllamaManager.getInstance().startEmbeddedContainer();
            }
            Integer proxify = null;
            if (this.context.get("proxy-port") != null) {
                proxify = Integer.parseInt(this.context.get("proxy-port").toString());
            }
            IPUtil.TRANSPORT_PROTOCOL protocol = IPUtil.TRANSPORT_PROTOCOL.HTTP;
            if (this.context.get("protocol") != null) {
                protocol = IPUtil.TRANSPORT_PROTOCOL.fromString((String)this.context.get("protocol").toString());
            }
            this.applicationUrl = new URI(IPUtil.createPrettyHost((String)this.conf.getHost(), (Integer)this.conf.getPort(), (IPUtil.TRANSPORT_PROTOCOL)protocol, (Integer)proxify) + "/" + this.getName() + this.getShortPath()).toString();
            if (this.queryPath != null) {
                this.applicationUrl = this.applicationUrl + "?" + this.queryPath;
            }
            this.application = DWApplicationService.generateJaxbApplication(this.getName(), conf, this.context);
            if (this.application != null) {
                this.applicationContext = this.createApplicationContext();
                this.initializeApplicationContext(this.applicationContext);
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public CoreResource getCoreResource() {
        return this.coreResource;
    }

    public ModelsResource getModelsResource() {
        return this.modelsResource;
    }

    public SystemResource getUserResource() {
        return this.systemResource;
    }

    public DWApplicationContextResource getContextResource() {
        return this.contextResource;
    }

    public static GJaxbApplication generateJaxbApplication(String name, Configuration conf, Map<String, Object> context) throws Exception {
        URL applicationModel = null;
        if (conf.getUrl().toString().startsWith("jar:")) {
            applicationModel = URIHelper.resolve((URI)conf.getUrl().toURI(), (String)((String)conf.getProperties().get("application"))).toURL();
        } else if (conf.getProperties().get("application") != null) {
            applicationModel = new File(new File(conf.getUrl().toURI()).getParentFile().getCanonicalFile(), (String)conf.getProperties().get("application")).getCanonicalFile().toURI().toURL();
        }
        GJaxbApplication application = null;
        if (applicationModel != null && applicationModel.getProtocol().equals("file")) {
            File appliFile = new File(applicationModel.toURI());
            if (!appliFile.exists()) {
                applicationModel = Thread.currentThread().getContextClassLoader().getResource("test/conf/generated/" + name + "/conf/Application.xml");
            }
            System.out.println("applicationModel: " + String.valueOf(applicationModel));
            String bufferApplication = FileUtil.getContents((InputStream)applicationModel.openStream());
            bufferApplication = bufferApplication.replace("##application_name##", name);
            Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(bufferApplication.getBytes()));
            application = (GJaxbApplication)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbApplication.class);
            if (application.getExtensions() == null) {
                application.setExtensions(new GJaxbApplication.Extensions());
            }
            context.put("application", application);
        }
        return application;
    }

    public URL getYmlConfig() {
        return this.ymlConfig;
    }

    public void initialize(Bootstrap<GenericConfiguration> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
        if (this.getName().equals("generic-application")) {
            this.interceptorBundle = new AssetsInterceptorBundle("/META-INF/resources/webjars", "/generic-application/webjars", new ExternalModifierResource(this.getName(), this.conf), new ApplicationNameModifierResource(this.getName()));
            bootstrap.addBundle((ConfiguredBundle)this.interceptorBundle);
        } else {
            this.interceptorBundle = new AssetsInterceptorBundle("/META-INF/resources/webjars", "/" + this.getName() + "/webjars", new ExternalModifierResource(this.getName(), this.conf), new ApplicationNameModifierResource(this.getName()));
            bootstrap.addBundle((ConfiguredBundle)this.interceptorBundle);
        }
    }

    public GJaxbApplication getApplication() {
        return this.application;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public <T extends ApplicationContext> T createApplicationContext() throws Exception {
        ApplicationContext applicationContext = new ApplicationContext(this);
        return (T)applicationContext;
    }

    public <T extends ApplicationContext> void initializeApplicationContext(T applicationContext) throws Exception {
        applicationContext.setApplication(this.application);
        applicationContext.getApplication().setBuildDate((String)this.conf.getProperties().get("generation-date"));
    }

    public void run(GenericConfiguration configuration, Environment env) throws Exception {
        this.environment = env;
        OpenAPI oas = new OpenAPI();
        Info info = new Info().title("R-IOSuite API").description("RESTful R-IOSuite Framework").termsOfService("https://r-iosuite.com/").contact(new Contact().email("gind-riosuite@mines-albi.fr"));
        oas.info(info);
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(oas).prettyPrint(Boolean.valueOf(true)).resourcePackages(Stream.of("fr.emac.gind.rio.dw.resources").collect(Collectors.toSet()));
        this.environment.jersey().register((Object)new OpenApiResource().openApiConfiguration((OpenAPIConfiguration)oasConfig));
        System.out.println("rsc config: " + String.valueOf(this.environment.jersey().getResourceConfig()));
        this.environment.jersey().register((Object)new RIOExceptionMapper());
        if (!SHARED_RESOURCES_LOADED) {
            DWApplicationService.copySharedResources();
            SHARED_RESOURCES_LOADED = true;
        }
        if (WEB_SOCKET_COMMAND == null && this.conf.getProperties().get("websocket-command-service-port") != null) {
            WEB_SOCKET_COMMAND = new WebsocketCommandImpl(this.conf.getPort().intValue());
            WEB_SOCKET_COMMAND_SERVER = StaticJettyServer.getInstance().publishJAXWSEndpoint(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("websocket-command-service-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/websocketCommandService"), (Object)WEB_SOCKET_COMMAND);
            LOG.info("WebsocketCommandService started at: " + SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("websocket-command-service-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/websocketCommandService"));
        }
        this.resourcesManager = new RestResourceManager(env);
        if (this.application != null) {
            this.fileResource = new FileResource(this.getName());
            this.resourcesManager.addResource(this.fileResource);
            this.resourcesManager.addResource(new StorageResource(this.conf));
            this.coreResource = new CoreResource(this.conf);
            this.metaModelsResource = new MetaModelsResource(this.conf, WEB_SOCKET_COMMAND);
            this.resourcesManager.addResource(new Neo4JResource(this.conf));
            this.resourcesManager.addResource(this.coreResource);
            this.modelsResource = new ModelsResource(this.conf, WEB_SOCKET_COMMAND, this.metaModelsResource);
            this.resourcesManager.addResource(this.modelsResource);
            this.resourcesManager.addResource(this.metaModelsResource);
            this.contextResource = new DWApplicationContextResource(this, this.applicationContext, this.conf, this.coreResource);
            this.resourcesManager.addResource(this.contextResource);
            this.systemResource = new SystemResource(this.applicationContext, this.conf);
            this.resourcesManager.addResource(this.systemResource);
            this.humanTaskResource = new HumanTaskResource(this.conf, this.modelsResource);
            this.resourcesManager.addResource(this.humanTaskResource);
            this.aiChatbotResource = new AIChatbotResource(this.conf, this.fileResource);
            this.resourcesManager.addResource(this.aiChatbotResource);
            this.hardCodedResource = new OnlyGetResource(this.conf, this.modelsResource, this.humanTaskResource);
            this.resourcesManager.addResource(this.hardCodedResource);
        }
        this.environment.jersey().register((Object)new JsonProcessingExceptionMapper(true));
        this.environment.jersey().register(MultiPartFeature.class);
        this.environment.healthChecks().register("dummy", (HealthCheck)new DummyHealthCheck());
        this.environment.jersey().register(RolesAllowedDynamicFeature.class);
        this.environment.jersey().register((Object)new AuthDynamicFeature((ContainerRequestFilter)new BasicCredentialAuthFilter.Builder().setAuthenticator(new BasicAuthenticator(this.systemResource)).setAuthorizer((Authorizer)new UserRoleAuthorizer()).setRealm("SUPER SECRET STUFF").buildAuthFilter()));
        this.environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(DWUser.class));
        this.environment.getApplicationContext().addServletContainerInitializer((ServletContainerInitializer)new JettyWebSocketServletContainerInitializer());
        ServletRegistration.Dynamic websocket = env.servlets().addServlet("ws_chat", (Servlet)new ChatServerServlet());
        websocket.setAsyncSupported(true);
        websocket.addMapping(new String[]{"/ws/chat/*"});
        this.doRun(configuration, env, this.resourcesManager);
        this.resourcesManager.registerAllResources();
        if (this.conf.getProperties().get("humantask-event-notifier-port") != null) {
            this.createNotifierForHumanTaskEvent();
        }
        FilterRegistration.Dynamic cors = this.environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        cors.setInitParameter("allowedOrigins", "*");
        cors.setInitParameter("Access-Control-Allow-Origin", "*");
        cors.setInitParameter("allowedMethods", "OPTIONS,GET,PUT,POST,DELETE,HEAD");
        cors.setInitParameter("allowCredentials", "true");
        cors.setInitParameter("allowedHeaders", "Cache-Control,If-Modified-Since,Pragma,Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin");
        cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        LOG.info("\n\nApplication started at : \n\t" + this.applicationUrl + "\n\n");
    }

    public abstract void doRun(io.dropwizard.core.Configuration var1, Environment var2, RestResourceManager var3) throws Exception;

    public static void startEmbeddedMongDB(boolean testMode, Configuration conf) throws Exception {
        if (embeddedMongoDB == null) {
            LOG.info("Start Embedded MongoDB");
            embeddedMongoDB = new EmbeddedMongoDb(conf);
            embeddedMongoDB.start(testMode);
        }
    }

    public RestResourceManager getResourcesManager() {
        return this.resourcesManager;
    }

    public static void stopEmbeddedMongDB() throws Exception {
        if (embeddedMongoDB != null) {
            LOG.info("Stop Embedded MongoDB");
            embeddedMongoDB.stop();
            embeddedMongoDB = null;
        }
    }

    public void activatePubSubServerServlet(Environment environment) throws Exception {
        if (this.pubSubWebsocket == null) {
            this.pubSubWebsocket = environment.servlets().addServlet("ws_pubsub", (Servlet)new PubSubServerServlet());
            this.pubSubWebsocket.setAsyncSupported(true);
            this.pubSubWebsocket.addMapping(new String[]{"/ws/pubsub/*"});
            ServletRegistration.Dynamic websocket = environment.servlets().addServlet("ws_sockjs", (Servlet)new SockJSServerServlet());
            websocket.setAsyncSupported(true);
            websocket.addMapping(new String[]{"/sockjs-node/*"});
        }
    }

    public void addWebSocketResources(Class<?> clazz) {
        this.webSocketResources.add(clazz);
    }

    public void stop() throws Exception {
        LOG.debug(this.getName() + "is going to stop.");
        if (this.environment != null && this.environment.getAdminContext() != null && this.environment.getAdminContext().getServer() != null) {
            this.environment.getAdminContext().getServer().stop();
            this.environment.getAdminContext().getServer().destroy();
        }
        if (this.environment != null && this.environment.getApplicationContext() != null && this.environment.getApplicationContext().getServer() != null) {
            this.environment.getApplicationContext().getServer().stop();
            this.environment.getApplicationContext().getServer().destroy();
        }
        if (WEB_SOCKET_COMMAND_SERVER != null) {
            StaticJettyServer.getInstance().unPublishJAXWSEndpoint(WEB_SOCKET_COMMAND_SERVER);
            WEB_SOCKET_COMMAND_SERVER.stop();
            WEB_SOCKET_COMMAND_SERVER = null;
        }
        if (ModelsResource.ASYNC_PUBLISH_EXTRACT_CONSUMER != null) {
            ModelsResource.ASYNC_PUBLISH_EXTRACT_CONSUMER.stop();
            ModelsResource.ASYNC_PUBLISH_EXTRACT_CONSUMER = null;
        }
        if (HUMAN_TASK_CONSUMER != null) {
            HUMAN_TASK_CONSUMER.stop();
            HUMAN_TASK_CONSUMER = null;
        }
        DWApplicationService.stopEmbeddedMongDB();
        OllamaManager.getInstance().stopEmbeddedContainer();
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    private void createNotifierForHumanTaskEvent() throws Exception {
        if (HUMAN_TASK_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("humantask-event-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/HumanTaskEventNotifierClient");
            final RIOHumanTaskNotifierClient notifier = new RIOHumanTaskNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName());
            HUMAN_TASK_CONSUMER = new NotificationConsumerWebService();
            HUMAN_TASK_CONSUMER.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ DWApplicationService this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", "0.0.0.0");
                    this.put("port", this.this$0.conf.getProperties().get("humantask-event-notifier-port"));
                    this.put("serviceName", "HumanTaskEventNotifierClient");
                    this.put("notifierClient", notifier);
                }
            });
        }
    }

    public static String generateIcon(SVGGenerator svgGen, GJaxbRelation edge, String collaborationName, String knowledgeSpaceName) throws Exception {
        Document doc = svgGen.createSVGFromEdge(edge);
        Object cn = "";
        if (collaborationName != null) {
            cn = (String)cn + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "/";
        }
        if (knowledgeSpaceName != null) {
            cn = (String)cn + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "/";
        }
        File target = new File(RIOConstant.RESOURCES_FOLDER);
        target = new File(target, "edges_icons/" + (String)cn);
        String webName = null;
        if (edge.getType() != null) {
            String fileName = RegExpHelper.toRegexFriendlyName((String)edge.getType().getLocalPart()) + ".svg";
            File svgFile = new File(target, fileName).getCanonicalFile();
            if (!svgFile.exists()) {
                target.mkdirs();
                svgFile.createNewFile();
                FileUtil.setContents((File)svgFile, (String)XMLPrettyPrinter.print((Node)doc));
            }
            webName = "/##application_name##/webjars/resourcesFolder/edges_icons/" + (String)cn + fileName;
            if (!edge.isSetEdgeMetaModeling()) {
                edge.setEdgeMetaModeling(new GJaxbEdgeMetaModeling());
            }
            if (!edge.getEdgeMetaModeling().isSetModelingEdgeViewDefinition()) {
                edge.getEdgeMetaModeling().setModelingEdgeViewDefinition(new GJaxbModelingEdgeViewDefinition());
            }
            edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().setIcon(webName);
        }
        return webName;
    }

    public static void copySharedResources() throws Exception {
        File target = new File(RIOConstant.RESOURCES_FOLDER);
        String shareDirectory = "META-INF/resources/webjars/app/share/";
        URL root = Thread.currentThread().getContextClassLoader().getResource(shareDirectory);
        LOG.debug("root - " + String.valueOf(root));
        if (root == null) {
            throw new Exception("Shared resources not found!!!");
        }
        Path myPath = null;
        if (root.getProtocol().equals("jar")) {
            LOG.debug("get mypath from jar");
            FileSystem fileSystem = null;
            try {
                fileSystem = FileSystems.getFileSystem(root.toURI());
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(root.toURI(), Collections.emptyMap());
            }
            myPath = fileSystem.getPath(shareDirectory, new String[0]);
        } else {
            LOG.debug("get mypath from file");
            myPath = Paths.get(root.toURI());
        }
        List collect = Files.walk(myPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toUri()).collect(Collectors.toList());
        for (URI shareFileInJar : collect) {
            String pathAndFileName = shareFileInJar.toString().substring(shareFileInJar.toString().indexOf("/share/"));
            LOG.debug("Copy share resource: " + pathAndFileName);
            File shareFileInFolder = new File(target, pathAndFileName);
            shareFileInFolder.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(shareFileInFolder);
            FileUtil.copy((InputStream)shareFileInJar.toURL().openStream(), (OutputStream)out);
            out.close();
        }
    }
}

