/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.humantask.GJaxbGetTodoList;
import fr.emac.gind.humantask.GJaxbGetTodoListResponse;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResource;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResourceResponse;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbTodoList;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.humantask.GJaxbUpdateTaskResponse;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/persons/humantask")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class HumanTaskResource {
    private static Logger LOG = LoggerFactory.getLogger((String)HumanTaskResource.class.getName());
    private Configuration conf = null;
    private Humantask htClient = null;
    private ModelsResource modelsResource = null;

    public HumanTaskResource(Configuration conf, ModelsResource modelsResource) throws Exception {
        this.conf = conf;
        this.htClient = HumanTaskClient.createClient((String)((String)conf.getProperties().get("humantask")));
        this.modelsResource = modelsResource;
    }

    @GET
    @Path(value="/todoList/{assignedToId}")
    public GJaxbGetTodoListResponse todoList(@Auth DWUser user, @PathParam(value="assignedToId") String userId, @QueryParam(value="qAssignedToId") String qAssignedToId, @QueryParam(value="addPersonalTask") Boolean addPersonalTask) throws Exception {
        GJaxbGetTodoListResponse response = null;
        assert (user != null);
        try {
            LOG.debug("qId = " + qAssignedToId);
            GJaxbGetTodoList request = new GJaxbGetTodoList();
            request.setAssignedToId(qAssignedToId);
            response = this.htClient.getTodoList(request);
            if (addPersonalTask != null && addPersonalTask.booleanValue()) {
                String query = null;
                query = qAssignedToId == null || qAssignedToId.equals("null") ? "match (r:`" + String.valueOf(GenericModelHelper.collab((String)"Resource")) + "`)-[pl:`" + String.valueOf(GenericModelHelper.collab((String)"Plans")) + "`]->(pt:`" + String.valueOf(GenericModelHelper.collab((String)"Personal_Task")) + "`) return distinct r, pl, pt" : "match (r:`" + String.valueOf(GenericModelHelper.collab((String)"Resource")) + "` { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)qAssignedToId, (String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName()) + "' })-[pl:`" + String.valueOf(GenericModelHelper.collab((String)"Plans")) + "`]->(pt:`" + String.valueOf(GenericModelHelper.collab((String)"Personal_Task")) + "`) return distinct r, pl, pt";
                GJaxbGenericModel modelPersoTasks = this.modelsResource.query(user, query, null);
                GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{modelPersoTasks});
                for (GJaxbNode personalTaskNode : man.getNodesByType(GenericModelHelper.collab((String)"Personal_Task"))) {
                    GJaxbTask personalTask = new GJaxbTask();
                    personalTask.setDeployedTaskId("null");
                    personalTask.setProcessInstanceId("null");
                    List plansEdges = man.findInputEdgesOfNode(personalTaskNode);
                    if (!plansEdges.isEmpty()) {
                        GJaxbEdge plansEdge = (GJaxbEdge)plansEdges.get(0);
                        personalTask.setPlansEdge(new GJaxbTask.PlansEdge());
                        personalTask.getPlansEdge().setEdge(plansEdge);
                        personalTask.getAssignedToIds().add(plansEdge.getSource().getId());
                    }
                    personalTask.setNode(personalTaskNode);
                    if (response.getTodoList() == null) {
                        response.setTodoList(new GJaxbTodoList());
                    }
                    response.getTodoList().getTask().add(personalTask);
                }
            }
            if (response.getTodoList() != null && response.getTodoList().getTask() != null) {
                for (GJaxbTask t : response.getTodoList().getTask()) {
                    if (t.getPlansEdge() != null && t.getPlansEdge().getEdge() != null) {
                        t.getPlansEdge().getEdge().setSource(null);
                        t.getPlansEdge().getEdge().setTarget(null);
                    }
                    if (!t.getNode().isSetBrokenEdges() || t.getNode().getBrokenEdges().getBrokenEdge().isEmpty()) continue;
                    t.getNode().getBrokenEdges().getBrokenEdge().forEach(be -> {
                        be.getEdge().setSource(null);
                        be.getEdge().setTarget(null);
                    });
                }
            }
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @PUT
    @Path(value="/updateTask")
    public GJaxbUpdateTaskResponse updateTask(@Auth DWUser user, String requestJson) throws Exception {
        GJaxbUpdateTaskResponse response = null;
        assert (user != null);
        try {
            GJaxbUpdateTask request = (GJaxbUpdateTask)JSONJAXBContext.getInstance().unmarshall("{ \"updateTask\" : " + requestJson + " }", GJaxbUpdateTask.class);
            response = this.updateTask(user, request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    public GJaxbUpdateTaskResponse updateTask(@Auth DWUser user, GJaxbUpdateTask request) throws Exception {
        GJaxbUpdateTaskResponse response = null;
        assert (user != null);
        try {
            assert (request.getDeployedTaskId() != null);
            LOG.debug("human request.getId(): " + request.getDeployedTaskId());
            response = this.htClient.updateTask(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @GET
    @Path(value="/subscribeToAddTasksByAssignedToResource/{assignedToId}")
    public GJaxbSubscribeTasksByAssignedToResourceResponse subscribeToAddTasksByAssignedToResource(@Auth DWUser user, @PathParam(value="assignedToId") String assignedToId, @QueryParam(value="qAssignToId") String qAssignToId) throws Exception {
        int port = Integer.parseInt((String)this.conf.getProperties().get("humantask-event-notifier-port"));
        String callbackAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)port, (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/HumanTaskEventNotifierClient");
        return this.subscribeToAddTasksByAssignedToResource(user, assignedToId, qAssignToId, callbackAddress, this.htClient);
    }

    public GJaxbSubscribeTasksByAssignedToResourceResponse subscribeToAddTasksByAssignedToResource(DWUser user, String assignedToId, String qAssignToId, String callbackAddress, Humantask client) throws Exception {
        GJaxbSubscribeTasksByAssignedToResourceResponse response = null;
        assert (user != null);
        try {
            LOG.debug("assignedToId = " + assignedToId);
            LOG.debug("qAssignToId = " + qAssignToId);
            QName topic = new QName("http://www.gind.emac.fr/HumanTaskTopic", "allHumanTaskTopic");
            GJaxbSubscribeTasksByAssignedToResource request = new GJaxbSubscribeTasksByAssignedToResource();
            request.getAssignedToIds().add(qAssignToId);
            request.setTopic(topic);
            request.setCallbackAddress(callbackAddress);
            response = client.subscribeTasksByAssignedToResource(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }
}

