/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.meta.models.client.MetaModelsGovClient;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomainResponse;
import fr.emac.gind.gov.meta_models_gov.GJaxbPublishSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.GJaxbPublishUnpublishResultType;
import fr.emac.gind.gov.meta_models_gov.GJaxbUnpublishSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.MetaModelsGov;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.websocket.command.WebsocketCommand;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/metamodels")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MetaModelsResource {
    private static Logger LOG = LoggerFactory.getLogger((String)MetaModelsResource.class.getName());
    private EffectiveMetaModelManager effMM = null;
    private MetaModelsGov metaModelsClient = null;
    private CoreGov coreClient = null;
    private Storage storageClient = null;
    private Configuration conf = null;
    public static SPIWebServicePrimitives ASYNC_PUBLISH_EXTRACT_CONSUMER = null;
    protected WebsocketCommand wEB_SOCKET_COMMAND = null;

    public MetaModelsResource(Configuration conf, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
        this.metaModelsClient = MetaModelsGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovMetaModels"));
        this.coreClient = CoreGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovCore"));
        this.storageClient = StorageClient.createClient((String)((String)conf.getProperties().get("storage")));
        this.conf = conf;
        this.wEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        Map allMetaModels = EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromMetaModelByQNameMap();
        this.effMM = new EffectiveMetaModelManager(allMetaModels.values().toArray(new GJaxbEffectiveMetaModel[allMetaModels.values().size()]));
    }

    public MetaModelsGov getMetaModelsClient() {
        return this.metaModelsClient;
    }

    @GET
    @Path(value="/getUMLEffectiveDomain")
    public GJaxbEffectiveDomain getUMLEffectiveDomain(@Auth DWUser user) throws Exception {
        GJaxbEffectiveDomain uml = new GJaxbEffectiveDomain();
        return EffectiveMetaModelPluginManager.getInstance().getUmlEffectiveDomain();
    }

    @POST
    @Path(value="/publishSyncEffectiveDomain")
    public GJaxbPublishUnpublishResultType publishSyncEffectiveDomain(@Auth DWUser user, GJaxbPublishSyncEffectiveDomain model) throws Exception {
        GJaxbPublishUnpublishResultType response = this.metaModelsClient.publishSyncEffectiveDomain(model);
        return response;
    }

    @POST
    @Path(value="/unpublishSyncEffectiveDomain")
    public GJaxbPublishUnpublishResultType unpublishSyncEffectiveDomain(@Auth DWUser user, GJaxbUnpublishSyncEffectiveDomain model) throws Exception {
        GJaxbPublishUnpublishResultType response = this.metaModelsClient.unpublishSyncEffectiveDomain(model);
        return response;
    }

    @POST
    @Path(value="/extractSyncEffectiveDomain")
    public GJaxbExtractSyncEffectiveDomainResponse extractSyncEffectiveDomain(@Auth DWUser user, GJaxbExtractSyncEffectiveDomain model) throws Exception {
        GJaxbExtractSyncEffectiveDomainResponse response = this.metaModelsClient.extractSyncEffectiveDomain(model);
        return response;
    }
}

